/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile

import android.annotation.SuppressLint
import android.webkit.WebChromeClient
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.core.view.isGone
import androidx.navigation.fragment.navArgs
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentFaqAndTermsOfUseBinding
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@AndroidEntryPoint
class FAQAndTermsOfUseFragment :
    BaseSDKDataFragment<FragmentFaqAndTermsOfUseBinding, FAQAndTermsOfUserViewModel>(
        R.layout.fragment_faq_and_terms_of_use,
        FAQAndTermsOfUserViewModel::class.java
    ) {

    private var isFAQ: Boolean = false
    private val args: FAQAndTermsOfUseFragmentArgs by navArgs()

    override fun setViewModel(): Int = BR.viewModel

    @SuppressLint("SetJavaScriptEnabled")
    override fun initViews() {
        with(binding) {
            webView.webViewClient = object : WebViewClient() {
                override fun onPageFinished(view: WebView?, url: String?) {
                    super.onPageFinished(view, url)
                    if (activity?.isFinishing == false && view != null) {
                        binding.progressLoading.isGone = true
                    }
                }
            }
            webView.webChromeClient = object : WebChromeClient() {
                override fun onProgressChanged(view: WebView?, newProgress: Int) {
                    super.onProgressChanged(view, newProgress)
                    if (newProgress == 100 && activity?.isFinishing == false && view != null) {
                        binding.progressLoading.isGone = true
                    }
                }
            }
            webView.settings.javaScriptEnabled = true
        }
        isFAQ = args.isFAQ
        if (isFAQ) {
            initViewForFAQ()
        } else {
            initViewForTermsOfUser()
        }
    }

    private fun initViewForFAQ() {
        with(binding) {
            toolbar.setTitle(resources.getString(R.string.profile_frequently_asked_questions))
            webView.loadUrl(this@FAQAndTermsOfUseFragment.viewModel.getContentForFAQ())
        }
    }

    private fun initViewForTermsOfUser() {
        with(binding) {
            toolbar.setTitle(resources.getString(R.string.profile_terms_of_use))
            webView.loadUrl(this@FAQAndTermsOfUseFragment.viewModel.getContentForTermsOfUser())
        }
    }

    override fun initData() {
    }

    override fun syncEvent() {
        binding.toolbar.setOnLeftClickListener { viewModel.onBack() }
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(binding.toolbar)
    }

    override fun onDestroyView() {
        with(binding) {
            webView.destroy()
        }
        super.onDestroyView()
    }
}
