/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import androidx.navigation.NavController
import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.type.Language
import com.netacom.full.basechat.BaseSDKViewModel
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.repository.SocketRepository
import com.netacom.lite.sdk.AppID
import com.netacom.lite.util.Constants
import dagger.hilt.android.lifecycle.HiltViewModel
import javax.inject.Inject

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@HiltViewModel
class FAQAndTermsOfUserViewModel @Inject constructor(
    private val preferencesHelperImpl: PreferencesHelperImpl,
    navigationDispatcher: Dispatcher<(NavController) -> Unit>,
    socketRepository: SocketRepository,
    groupRepository: GroupRepository
) : BaseSDKViewModel(socketRepository, groupRepository, navigationDispatcher) {

    fun getContentForFAQ(): String {
        if (appId() == AppID.GALO) {
            return when (LanguageUtils.getLanguage()) {
                Language.ENGLISH.value -> Constants.URL_GALO_FAQ_EN
                Language.VIETNAMESE.value -> Constants.URL_GALO_FAQ_VN
                else -> Constants.URL_GALO_FAQ_VN
            }
        }
        return when (LanguageUtils.getLanguage()) {
            Language.ENGLISH.value -> Constants.URL_FAQ_EN
            Language.VIETNAMESE.value -> Constants.URL_FAQ_VN
            else -> Constants.URL_FAQ_VN
        }
    }

    fun getContentForTermsOfUser(): String {
        if (appId() == AppID.GALO) {
            return when (LanguageUtils.getLanguage()) {
                Language.ENGLISH.value -> Constants.URL_GALO_TERM_OF_USE_EN
                Language.VIETNAMESE.value -> Constants.URL_GALO_TERM_OF_USE_VN
                else -> Constants.URL_GALO_TERM_OF_USE_VN
            }
        }
        return when (LanguageUtils.getLanguage()) {
            Language.ENGLISH.value -> Constants.URL_TERM_OF_USE_EN
            Language.VIETNAMESE.value -> Constants.URL_TERM_OF_USE_VN
            else -> Constants.URL_TERM_OF_USE_VN
        }
    }
}
