/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile

import androidx.core.content.ContextCompat
import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.type.Language
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.ViewLanguageDialogBottomBinding
import dagger.hilt.android.AndroidEntryPoint
import java.util.Locale

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@AndroidEntryPoint
class LanguageDialogBottomFragment :
    BaseSDKBottomDialog<ViewLanguageDialogBottomBinding, LanguageViewModel>(
        R.layout.view_language_dialog_bottom,
        LanguageViewModel::class.java
    ) {

    override fun setViewModel(): Int = BR.viewModel

    override fun initData() {}

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_SMALL

    override fun setupTheme() {}

    private fun applyEnglishForView() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(binding.tvEnglish)
            tvVietnamese.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_text))
        }
    }

    private fun applyVietnameseForView() {
        with(binding) {
            themeHelperImpl.setThemeColorForViews(binding.tvVietnamese)
            tvEnglish.setTextColor(ContextCompat.getColor(requireContext(), R.color.color_text))
        }
    }

    override fun getTheme(): Int = com.netacom.base.chat.R.style.dialogStyle

    override fun initViews() {
        viewModel.getCurrentLanguage()
        viewModel.language.observe {
            when (it) {
                Language.ENGLISH.value -> applyEnglishForView()
                Language.VIETNAMESE.value -> applyVietnameseForView()
            }
        }

        with(binding) {

            tvCancel.clickDebounce { dismiss() }

            tvEnglish.clickDebounce {
                LanguageUtils.applyLanguage(Locale(Language.ENGLISH.value))
                dismiss()
            }

            tvVietnamese.clickDebounce {
                LanguageUtils.applyLanguage(Locale(Language.VIETNAMESE.value))
                dismiss()
            }
        }
    }
}
