/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.base.chat.type.Language
import com.netacom.lite.hilt.executor.PostExecutionThread
import dagger.hilt.android.lifecycle.HiltViewModel
import javax.inject.Inject

/**
Created by vietnguyen on 18/Sep/2020
Company: Netacom.
 **/
@HiltViewModel
class LanguageViewModel @Inject constructor(
    private val postExecutionThread: PostExecutionThread
) : BaseViewModel() {

    val language: LiveData<String>
        get() = _language
    private val _language = MutableLiveData<String>()

    fun getCurrentLanguage() {
        launchOnViewModelScope(postExecutionThread.io) {
            language.post(LanguageUtils.getLanguage() ?: Language.VIETNAMESE.value)
        }
    }
}
