/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile

import android.annotation.SuppressLint
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.fragment.app.activityViewModels
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.type.Language
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentProfileBinding
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.utils.DialogUtil
import com.netacom.lite.sdk.AppID
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/

@AndroidEntryPoint
class ProfileFragment : BaseSDKDataFragment<FragmentProfileBinding, ProfileViewModel>(R.layout.fragment_profile, ProfileViewModel::class.java) {

    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        if (themeHelperImpl.isDarkMode) {
            binding.tvTheme.text = StringUtils.getString(R.string.dark)
        } else {
            binding.tvTheme.text = StringUtils.getString(R.string.light)
        }
        viewModel.language.observe {
            when (it) {
                Language.ENGLISH.value -> binding.tvLanguage.text = getString(R.string.common_language_english)
                Language.VIETNAMESE.value -> binding.tvLanguage.text = getString(R.string.common_language_vn)
            }
        }
    }

    override fun initData() {
        if (viewModel.appId() == AppID.GALO) {
            binding.tvEmail.text = getString(R.string.profile_help_email_galo)
            with(binding) {
                imgReferral.setImageDrawable(ContextCompat.getDrawable(requireContext(), R.drawable.ic_bg_galo))
                tvTitle.isGone = true
                tvContent.isGone = true
                btnLanguageSetting.isGone = true
                tvLanguage.isGone = true
            }
        }
    }

    override fun syncEvent() {
        binding.btnLogOutSetting.clickDebounce {
            DialogUtil.showLogOutConfirm(
                requireContext(),
                {
                    mainSdkViewModel.logout {
                        viewModel.onBackLogin()
                        activity?.finishAffinity()
                    }
                },
                themeHelperImpl = themeHelperImpl
            )
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    override fun setupTheme() {
        with(binding) {
            if (this@ProfileFragment.viewModel.appId() != AppID.NETALO_DEV || this@ProfileFragment.viewModel.appId() != AppID.NETALO_PROD) {
                requireContext().let {
                    themeHelperImpl.setThemeColorForViews(tvName)
                    tvBlockList.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_block_list)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnNotificationSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_notif_setting)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnThemeSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_theme)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnLanguageSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_language)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnQaqSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_faq_account)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnTermsOfUseSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_term_account)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnSupportSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_support)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                    btnLogOutSetting.setCompoundDrawablesWithIntrinsicBounds(
                        themeHelperImpl.setThemeColorForDrawable(it.getDrawable(R.drawable.ic_logout)),
                        null,
                        it.getDrawable(R.drawable.ic_next),
                        null
                    )
                }
            }
            if (themeHelperImpl.referralDrawableId > 0) {
                imgReferral.setImageResource(themeHelperImpl.referralDrawableId)
            }
        }
    }

    override fun onResume() {
        super.onResume()
        viewModel.refreshLanguage()
    }
}
