/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import android.net.Uri
import androidx.core.content.ContextCompat
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import androidx.core.widget.doAfterTextChanged
import androidx.navigation.fragment.navArgs
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.android_utils.UriUtils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadAvatar
import com.netacom.base.chat.type.Result
import com.netacom.base.chat.util.setup
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseCoreCallCameraFragment
import com.netacom.full.databinding.FragmentUpdateProfileBinding
import com.netacom.full.extensions.hideKeyboard
import com.netacom.full.ui.sdk.NetAloSDK
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
Created by vietnguyen on 30/Sep/2020
Company: Netacom.
Email: vietnt@netacom.vn
 **/
@AndroidEntryPoint
class ProfileUpdateFragment :
    BaseCoreCallCameraFragment<FragmentUpdateProfileBinding, ProfileViewModel>(
        R.layout.fragment_update_profile,
        ProfileViewModel::class.java
    ) {
    override fun setViewModel(): Int = BR.viewModel
    private val args: ProfileUpdateFragmentArgs by navArgs()
    private var isUploadImage: Boolean = false

    private var hasChangedAvatar: Boolean = false
    private var avatarFile: Uri? = null

    override fun initViews() {
        with(binding) {
            toolbarInfo.setColorTextLeft(ContextCompat.getColor(requireContext(), R.color.color_text_left_toolbar))
            if (args.isNewUser) { // if is new user => set title is update info and left action is skip
                toolbarInfo.setTitle(requireContext().resources.getString(R.string.update_info))
                toolbarInfo.setTextLeft(requireContext().resources.getString(R.string.skip))
            } else { // else => set title is update profile and left action is cancel
                toolbarInfo.setTitle(requireContext().resources.getString(R.string.profile_title))
                toolbarInfo.setTextLeft(requireContext().resources.getString(R.string.common_cancel))
            }
            toolbarInfo.setEnableActionRight(false)
        }
    }

    override fun initData() {
        isUploadImage = false
        capture.observeOnce { result ->
            result.let {
                avatarFile = it
                hasChangedAvatar = true
                with(binding) {
                    ivProfileAvatar.loadAvatar(it)
                    tvUpdate.isEnabled = true
                }
            }
        }

        if (!args.isNewUser) {
            if (viewModel.getUserName == StringUtils.getString(R.string.unknown_user)) {
                viewModel.getUser?.phone?.let { phone ->
                    binding.txtName.setText(phone)
                    binding.txtName.hint = phone
                }
            } else {
                binding.txtName.setText(viewModel.getUserName)
                binding.txtName.hint = viewModel.getUserName
            }
        } else {
            viewModel.getUser?.phone?.let { phone ->
                binding.txtName.setText(phone)
                binding.txtName.hint = phone
            }
        }
    }

    override fun syncEvent() {
        with(binding) {
            toolbarInfo.setOnLeftClickListener {
                if (!args.isNewUser) {
                    hideKeyboard()
                    MainScope().launch {
                        delay(100)
                        this@ProfileUpdateFragment.viewModel.onBack()
                    }
                } else {
                    // action [skip] in first update info
                    activity?.finish()
                    NetAloSDK.openNetAlo(requireContext())
                }
            }

            toolbarInfo.setOnRightClickListener {
                actionUpdateProfile()
            }

            txtName.doAfterTextChanged {
                val curText = it.toString()
                when {
                    curText.isNotEmpty() -> {
                        imgClearName.isVisible = true
                        imgClearName.clickDebounce {
                            txtName.setText("")
                        }
                        (curText.trim() == this@ProfileUpdateFragment.viewModel.user.value?.username).let { isCheck ->
                            tvUpdate.isEnabled = !isCheck
                            if (isCheck) {
                                toolbarInfo.hideActionRight()
                            } else {
                                toolbarInfo.showActionRight()
                            }
                        }
                    }
                    curText.isEmpty() -> {
                        if (isUploadImage) {
                            tvUpdate.isEnabled = true
                            toolbarInfo.hideActionRight()
                        } else {
                            tvUpdate.isEnabled = false
                            imgClearName.isInvisible = true
                            toolbarInfo.hideActionRight()
                        }
                    }
                }
            }

            layoutAvatar.clickDebounce {
                checkPermissionStorage(
                    {
                        openSelectMediaDialog()
                    },
                    {
                    }
                )
            }
            tvUpdate.clickDebounce {
                actionUpdateProfile()
            }
            tvUpdate.setup(
                activity = activity,
                actionLiveData = this@ProfileUpdateFragment.viewModel.updateAction,
                successMsgRes = R.string.popup_confirm_create_password
            ) { result, _ ->
                when (result) {
                    Result.DOING -> {
                    }
                    Result.SUCCESS -> {
                        if (args.isNewUser) {
                            activity?.finish()
                            NetAloSDK.openNetAlo(requireContext())
                        } else {
                            this@ProfileUpdateFragment.viewModel.onBack()
                        }
                    }
                    Result.FAIL -> showSnackBar(this@ProfileUpdateFragment.viewModel.updateAction.value?.message.toString())
                }
            }
        }
    }

    private fun openSelectMediaDialog() {
        viewModel.openChooseMediaFragment(isChat = false)
    }

    override fun setupTheme() {
        with(binding) {
            themeHelperImpl.apply {
                setThemeColorForViews(
                    toolbarInfo.getTextRight()!!,
                    txtName,
                    txtPhoneNumber,
                    imgPhoneLock
                )
                setThemeStateListForButtonAction(tvUpdate)
            }
        }
    }

    private fun actionUpdateProfile() {
        if (hasChangedAvatar && avatarFile != null) {
            viewModel.updateProfileWithAvatar(
                name = binding.txtName.text.toString(),
                file = UriUtils.uri2File(avatarFile)
            )
        } else {
            viewModel.updateProfile(
                name = binding.txtName.text.toString()
            )
        }
    }
}
