/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import android.content.Context
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.navigation.NavController
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.WorkInfo
import androidx.work.WorkManager
import androidx.work.workDataOf
import com.netacom.base.chat.android_utils.LanguageUtils
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.base.ActionLiveData
import com.netacom.base.chat.json.JsonSerializer
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKViewModel
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.full.extensions.navigateIfSafe
import com.netacom.full.worker.upload.UploadWorker
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.BlockedItem
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.network.model.FileUpload
import com.netacom.lite.network.model.response.UploadResult
import com.netacom.lite.repository.AuthRepository
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.repository.SocketRepository
import com.netacom.lite.repository.UploadRepository
import com.netacom.lite.sdk.AppID
import com.netacom.lite.socket.request.BlockListRequest
import com.netacom.lite.util.AppUtils
import com.netacom.lite.util.CallbackResult
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.collect
import kotlinx.coroutines.withContext
import java.io.File
import javax.inject.Inject

/**
Created by vantoan on 03/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltViewModel
class ProfileViewModel @Inject constructor(
    private val socketRepository: SocketRepository,
    private val authRepository: AuthRepository,
    private val uploadRepository: UploadRepository,
    private val groupRepository: GroupRepository,
    private val jsonSerializer: JsonSerializer,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>
) : BaseSDKViewModel(socketRepository, groupRepository, navigationDispatcher) {
    val updateAction: ActionLiveData<ActionData<String>> = ActionLiveData()
    val isShowReferral = MutableLiveData(authRepository.getReferral()?.referral ?: false)
    val user = MutableLiveData(authRepository.getUser())
    val token = MutableLiveData(authRepository.getToken())
    val language = MutableLiveData(LanguageUtils.getLanguage())
    private val _contactHasConversation = MutableLiveData<EventLiveData<List<NeUser>>>()
    val contactHasConversation: LiveData<EventLiveData<List<NeUser>>> = _contactHasConversation

    fun refreshLanguage() {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val languages = LanguageUtils.getLanguage()
            Logger.e("refreshLanguage==" + languages)
            language.post(languages)
        }
    }

    /*
    private val _firstName = MutableStateFlow("")
    val isSubmitEnabled: Flow<Boolean> = combine(_firstName, _password, _userID) { firstName, password, userId ->
            val regexString = "[a-zA-Z]+"
            val isNameCorrect = firstName.matches(regexString.toRegex())
            val isPasswordCorrect = password.length > 8
            val isUserIdCorrect = userId.contains("_")
            return@combine isNameCorrect and isPasswordCorrect and isUserIdCorrect
        }*/
    fun updateProfile(name: String? = null) {
        updateAction.setDoing()
        launchOnViewModelScope(getPostExecutionThread.io) {
            authRepository.updateProfile(name = name, avatar = user.value?.avatar).collect {
                if (it is ApiResponseSuccess) {
                    authRepository.getProfile(
                        authRepository.getToken(),
                        authRepository.getUser()?.id.toString()
                    ).collect { it1 ->
                        run {
                            if (it1 is ApiResponseSuccess) {
                                user.post(authRepository.getUser())
                                updateAction.postSuccess()
                            } else {
                                updateAction.postErrorMsg(it1.message)
                            }
                        }
                    }
                } else {
                    updateAction.postErrorMsg(it.message)
                }
            }
        }
    }

//    private fun uploadFile(filePath: String) {
//        launchOnViewModelScope(getPostExecutionThread.io) {
//            val uploadWorkRequest = OneTimeWorkRequestBuilder<UploadWorker>().setInputData(
//                workDataOf(
//                    UploadWorker.KEY_THUMBNAIL_ARG to true,
//                    UploadWorker.KEY_ENCRYPT_ARG to false,
//                    UploadWorker.KEY_MEDIA_TYPE_ARG to jsonSerializer.asJson(MediaType.PHOTO, MediaType::class.java),
//                    UploadWorker.KEY_UPLOAD_FILE_ARG to jsonSerializer.asJson(FileUpload(filePath), FileUpload::class.java)
//                )
//            ).build()
//            WorkManager.getInstance(Utils.getApp()).enqueue(uploadWorkRequest)
//            withContext(getPostExecutionThread.main) {
//                WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(uploadWorkRequest.id).observeForever { workInfo ->
//                    if (workInfo != null && workInfo.state.isFinished) {
//                        jsonSerializer.asObject(workInfo.outputData.getString(UploadWorker.KEY_UPLOAD_RESULT), UploadResult::class.java)?.let {
//                            if (it.status == UploadResult.UploadResultStatus.SUCCESS) {
//                                user.postValue(user.value?.copy(avatar = it.fileUrl))
//                            } else if (it.status == UploadResult.UploadResultStatus.FAIL) {
//                                Logger.e("Upload avatar fail")
//                            }
//                        }
//                    }
//                }
//            }
//        }
//    }

    fun onBackLogin() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openLogin())
        }
    }

    fun gotoReferral() {
        navigationDispatcher.emit {
            if (appId() == AppID.GALO) {
                authRepository.getReferral()?.popups?.get(0)?.click_url?.apply {
                    if (this.isNotEmpty()) {
                        it.navigateIfSafe(ProfileFragmentDirections.openCampaign(url = this))
                    }
                }
            } else {
                it.navigateIfSafe(ProfileFragmentDirections.openReferral())
            }
        }
    }

    fun onEditProfile() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openProfileUpdate())
        }
    }

    fun onNotificationSetting(context: Context) {
        AppUtils.notificationSetting(context)
    }

    fun gotoFAQ() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openFaqAndTermOfUsers(true))
        }
    }

    fun gotoTermOfUser() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openFaqAndTermOfUsers(false))
        }
    }

    fun gotoTheme() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openTheme())
        }
    }

    fun goToBlockList() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openBlockList())
        }
    }

    fun gotoLanguage() {
        navigationDispatcher.emit {
            it.navigateIfSafe(ProfileFragmentDirections.openLanguage())
        }
    }

    fun goToAddBlock() {
        navigationDispatcher.emit { nav ->
            nav.navigateIfSafe(BlockListFragmentDirections.addUserToBlockList())
        }
    }

    fun getEmail() {
        AppUtils.email(
            StringUtils.getString(R.string.profile_help_email),
            StringUtils.getString(R.string.profile_help)
        )
    }

    fun getBlockList(callbackResult: CallbackResult<List<BlockedItem>>) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val blockListRequest = BlockListRequest(mUin = getUserId, pindex = 0, psize = 0)
            getIOSocket.getBlockList(blockListRequest)?.let { blockedList ->
                blockedList.mapNotNull {
                    groupRepository.getUserById(it.uin.toLongOrNull() ?: 0L)?.let { user ->
                        BlockedItem(neUser = user, groupId = it.groupId.toLongOrNull() ?: 0L)
                    }
                }.apply {
                    callbackResult.callBackSuccess(this)
                }
            }
        }
    }

    fun filterContactHasConversation(listContact: List<NeUser>) {
        launchOnViewModelScope(getPostExecutionThread.io) {
            val listContactHasConversation = listContact.filter { user ->
                groupRepository.getGroupOneToOneByUserId(user.id ?: 0).isNotNull
            }
            _contactHasConversation.postValue(EventLiveData(listContactHasConversation))
        }
    }

//    fun updateProfileWithAvatar(name: String? = null, file: File) {
//        Logger.e("000000000000000")
//        updateAction.setDoing()
//        launchOnViewModelScope(getPostExecutionThread.io) {
//            val result = uploadRepository.uploadFiles(isThumbnail = false, isEncryptedFile = false, MediaType.PHOTO, FileUpload(file.absolutePath))
//            if (result.status == UploadResult.UploadResultStatus.FAIL) {
//                Logger.d("Upload Avatar Fail!")
//            } else {
//                result.fileUrl?.let { avatarUrl ->
//                    authRepository.updateProfile(name = name, avatar = avatarUrl).collect { apiResponse ->
//                        if (apiResponse is ApiResponseSuccess) {
//                            authRepository.getProfile(
//                                authRepository.getToken(),
//                                authRepository.getUser()?.id.toString()
//                            ).collect { it1 ->
//                                run {
//                                    if (it1 is ApiResponseSuccess) {
//                                        user.post(authRepository.getUser())
//                                        updateAction.postSuccess()
//                                        Logger.e("1111111111111111111")
//                                    } else {
//                                        updateAction.postErrorMsg(it1.message)
//                                    }
//                                }
//                            }
//                        } else {
//                            updateAction.postErrorMsg(result.message)
//                        }
//                    }
//                }
//            }
//        }
//    }

    fun updateProfileWithAvatar(name: String? = null, file: File) {
        updateAction.setDoing()
        launchOnViewModelScope(getPostExecutionThread.io) {
            val uploadWorkRequest = OneTimeWorkRequestBuilder<UploadWorker>().setInputData(
                workDataOf(
                    UploadWorker.KEY_THUMBNAIL_ARG to false,
                    UploadWorker.KEY_ENCRYPT_ARG to false,
                    UploadWorker.KEY_MEDIA_TYPE_ARG to jsonSerializer.asJson(MediaType.PHOTO, MediaType::class.java),
                    UploadWorker.KEY_UPLOAD_FILE_ARG to jsonSerializer.asJson(FileUpload(file.absolutePath), FileUpload::class.java)
                )
            ).build()
            WorkManager.getInstance(Utils.getApp()).enqueue(uploadWorkRequest)
            withContext(getPostExecutionThread.main) {
                WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(uploadWorkRequest.id).observeForever(object : Observer<WorkInfo> {
                    override fun onChanged(workInfo: WorkInfo?) {
                        if (workInfo != null && workInfo.state.isFinished) {
                            jsonSerializer.asObject(workInfo.outputData.getString(UploadWorker.KEY_UPLOAD_RESULT), UploadResult::class.java)?.let {
                                when (it.status) {
                                    UploadResult.UploadResultStatus.SUCCESS -> {
                                        it.fileUrl?.let { avatarUrl ->
                                            launchOnViewModelScope(getPostExecutionThread.io) {
                                                authRepository.updateProfile(name = name, avatar = avatarUrl).collect { apiResponse ->
                                                    if (apiResponse is ApiResponseSuccess) {
                                                        authRepository.getProfile(
                                                            authRepository.getToken(),
                                                            authRepository.getUser()?.id.toString()
                                                        ).collect { it1 ->
                                                            run {
                                                                if (it1 is ApiResponseSuccess) {
                                                                    user.post(authRepository.getUser())
                                                                    updateAction.postSuccess()
                                                                } else {
                                                                    updateAction.postErrorMsg(it1.message)
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        updateAction.postErrorMsg(it.message)
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    UploadResult.UploadResultStatus.FAIL -> {
                                        Logger.d("Upload Avatar Fail!")
                                    }
                                    else -> {
                                        Logger.d("Upload Avatar Fail!")
                                    }
                                }
                            }
                        }
                        WorkManager.getInstance(Utils.getApp()).getWorkInfoByIdLiveData(uploadWorkRequest.id).removeObserver(this)
                    }
                })
            }
        }
    }
}
