/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import android.content.res.ColorStateList
import android.view.View
import androidx.core.content.ContextCompat
import androidx.core.widget.doAfterTextChanged
import com.netacom.base.chat.android_utils.KeyboardUtils
import com.netacom.base.chat.type.Result
import com.netacom.base.chat.util.setup
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKDataFragment
import com.netacom.full.databinding.FragmentReferralCodeBinding
import com.netacom.full.extensions.setFocusable
import com.netacom.full.utils.DialogUtil
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vantoan on 31,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

@AndroidEntryPoint
class ReferralCodeFragment : BaseSDKDataFragment<FragmentReferralCodeBinding, ReferralViewModel>(
    R.layout.fragment_referral_code,
    ReferralViewModel::class.java
) {
    override fun setViewModel(): Int = BR.viewModel

    override fun initViews() {
        binding.toolbarInfo.setOnLeftClickListener {
            backProfile()
        }
    }

    override fun initData() {
        with(binding) {
            editCode.setFocusable()
            activity?.apply {
                KeyboardUtils.showSoftInput(this)
            }
            editCode.doAfterTextChanged {
                it ?: return@doAfterTextChanged
                ivClear.visibility = if (it.isNotEmpty()) View.VISIBLE else View.GONE
                txtConfirm.isEnabled = it.trim().isNotEmpty()
                if (txtConfirm.isEnabled) {
                    txtConfirm.backgroundTintList = ColorStateList.valueOf(
                        ContextCompat.getColor(
                            requireContext(),
                            themeHelperImpl.mainColor
                        )
                    )
                } else {
                    if (themeHelperImpl.isDarkMode) {
                        txtConfirm.backgroundTintList = ColorStateList.valueOf(
                            ContextCompat.getColor(
                                requireContext(),
                                R.color.color_grey_b7b7b7
                            )
                        )
                    } else {
                        txtConfirm.backgroundTintList = ColorStateList.valueOf(
                            ContextCompat.getColor(
                                requireContext(),
                                R.color.color_grey_b7b7b7
                            )
                        )
                    }
                }
            }

            ivClear.setOnClickListener {
                this@ReferralCodeFragment.viewModel.cleanReferral()
            }

            txtConfirm.setup(
                activity = activity,
                actionLiveData = this@ReferralCodeFragment.viewModel.referralAction,
                successMsgRes = R.string.profile_referral_code_ok
            ) { result, _ ->
                when (result) {
                    Result.DOING -> {
                    }
                    Result.SUCCESS -> {
                        DialogUtil.showMessage(
                            requireContext(),
                            title = R.string.common_notification,
                            message = R.string.common_successfully,
                            okLabel = R.string.popup_confirm_logout_ok,
                            okFunc = {
                                backProfile()
                            },
                            themeHelperImpl = themeHelperImpl
                        )
                    }
                    Result.FAIL -> {
                        DialogUtil.showMessage(
                            requireContext(),
                            okButtonIsGone = false,
                            title = R.string.common_notification,
                            message = R.string.common_incorrect,
                            okLabel = R.string.popup_confirm_logout_ok,
                            cancelLabel = R.string.popup_confirm_logout_no,
                            okFunc = {
                            },
                            cancelFunc = {
                                backProfile()
                            },
                            themeHelperImpl = themeHelperImpl
                        )
                    }
                }
            }
        }
    }

    override fun syncEvent() {
        viewModel.cleanReferral.observeOnce {
            if (it) {
                with(binding.editCode) {
                    setText("")
                    setFocusable()
                }
            }
        }
    }

    override fun setupTheme() {
        with(binding) {
            toolbarInfo.getButtonLeft()?.let {
                themeHelperImpl.setThemeColorForViews(
                    editCode,
                    it
                )
            }
        }
    }

    private fun backProfile() {
        activity?.apply {
            KeyboardUtils.hideSoftInput(this)
        }
        viewModel.onBack()
    }
}
