/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.navigation.NavController
import com.netacom.base.chat.base.ActionData
import com.netacom.base.chat.base.ActionLiveData
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.base.chat.network.ApiResponseSuccess
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.lite.hilt.executor.PostExecutionThread
import com.netacom.lite.repository.AuthRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.collect
import javax.inject.Inject

/**
Created by vantoan on 31,July,2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltViewModel
class ReferralViewModel @Inject constructor(
    private val authRepository: AuthRepository,
    private val postExecutionThread: PostExecutionThread,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>
) : BaseViewModel() {

    val referralAction: ActionLiveData<ActionData<EventLiveData<Boolean>>> = ActionLiveData()
    private var _cleanReferral = MutableLiveData<EventLiveData<Boolean>>()
    val cleanReferral: LiveData<EventLiveData<Boolean>> = _cleanReferral

    fun cleanReferral() {
        cleanReferral.post(EventLiveData(true))
    }

    fun applyReferralCode(code: String) {
        referralAction.setDoing()
        launchOnViewModelScope(postExecutionThread.io) {
            authRepository.applyReferralCode(code).collect {
                if (it is ApiResponseSuccess) {
                    referralAction.postSuccess()
                } else {
                    referralAction.postError()
                }
            }
        }
    }

    fun onBack() {
        navigationDispatcher.emit {
            it.popBackStack()
        }
    }
}
