/*
* *Created by NetaloTeamAndroid on 2020
* Company: Netacom.
*  *
*/
package com.netacom.full.ui.main.profile

import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.core.os.bundleOf
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.fragment.app.activityViewModels
import androidx.fragment.app.setFragmentResult
import androidx.navigation.fragment.navArgs
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.define.DialogDef
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.BR
import com.netacom.full.R
import com.netacom.full.basechat.BaseSDKBottomDialog
import com.netacom.full.databinding.FragmentSelectPhotoBinding
import com.netacom.full.define.LoadType
import com.netacom.full.ui.main.MainSdkViewModel
import com.netacom.full.ui.main.profile.adapter.SelectMediaAdapter
import com.netacom.full.ui.main.profile.adapter.SelectPhotoAction
import com.netacom.full.utils.DialogUtil
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.local.LocalFileModel
import com.netacom.lite.sdk.AppID
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

@AndroidEntryPoint
class SelectMediaFragment :
    BaseSDKBottomDialog<FragmentSelectPhotoBinding, SelectMediaViewModel>(
        R.layout.fragment_select_photo,
        SelectMediaViewModel::class.java
    ) {
    private val TAG: String = SelectMediaFragment::class.java.simpleName
    private var isChat: Boolean = false
    private var isSdk: Boolean = false
    private var adapter: SelectMediaAdapter? = null
    private val args: SelectMediaFragmentArgs by navArgs()
    private val mainSdkViewModel: MainSdkViewModel by activityViewModels()

    companion object {
        const val OPEN_CAMERA = "OPEN_CAMERA"
        const val SELECT_PHOTO_VIDEO = "SELECT_PHOTO_VIDEO"
        const val SELECT_FILE = "SELECT_FILE"
    }

    override fun setViewModel(): Int = BR.viewModel

    override fun setLayoutHeight(): Int = DialogDef.LAYOUT_FULL

    override fun initViews() {
        isChat = args.isChat
        isSdk = args.isSDK
        initData()
        if (args.neMessage.isNotNull) {
            binding.llFileType.isGone = true
            binding.rcvSelectPhotos.isGone = true
            binding.layoutLiveTrip.isGone = true
            binding.llTitleShareLocation.isGone = true
            binding.layoutSendCurrentLocation.isClickable = false
        } else {
            initUiMedia()
        }
        initAction()
    }

    private fun initUiMedia() {
        with(binding) {
            if (!args.isShowDocumented) {
                llFileType.isGone = true
                layoutLiveTrip.isGone = true
                llTitleShareLocation.isGone = true
                layoutSendCurrentLocation.isClickable = false
            }
            if (isChat) {
                tvPhotoAndVideo.isVisible = true
                tvDocuments.isVisible = true
                if (viewModel.appId() == AppID.GALO) {
                    tvLocation.isVisible = true
                }
            } else {
                tvPhotoAndVideo.isVisible = true
                tvDocuments.isGone = true
                tvLocation.isGone = true
            }
            pbFileLoading.isVisible = true
            setViewSelected(true, tvPhotoAndVideo)
            setViewSelected(false, tvDocuments)
            setViewSelected(false, tvLocation)

            binding.rlSelected.isEnabled = false

            // check if netacom.com.netacom.base.chat show button select
            binding.rlSelected.isGone = true

            adapter = SelectMediaAdapter(themeHelperImpl = themeHelperImpl, maxSelections = args.maxSelections)
            adapter?.setParentCallback(
                callback = object : SelectPhotoAction {
                    override fun onOpenCamera() {
                        setFragmentResult(OPEN_CAMERA, bundleOf())
                        dismiss()
                    }

                    override fun updateCount(count: Int) {
                        if (isChat) {
                            rlSelected.isEnabled = count > 0
                            tvSendCount.text = String.format(getString(R.string.send_count), count)
                            if (count > 0) {
                                rlSelected.isVisible = true
                            } else {
                                rlSelected.isGone = true
                            }
                        } else {
                            val listPathSelected = adapter?.getListSelectedPhotos()
                            if (listPathSelected.isNotNull || listPathSelected?.size == 1) {
                                setFragmentResult(SELECT_PHOTO_VIDEO, bundleOf("data" to listPathSelected))
                                dismiss()
                            }
                        }
                    }

                    override fun onSelectedDocument(document: LocalFileModel) {
                        setFragmentResult(SELECT_FILE, bundleOf("data" to document))
                        viewModel.sendListFile(document)
                        dismiss()
                        if (isSdk) {
                            activity?.finish()
                        }
                    }

                    override fun selectFull() {
                        DialogUtil.showError(
                            context = requireContext(),
                            title = R.string.popup_confirm,
                            messageString = String.format(getString(R.string.maximum_file_select), if (isSdk) args.maxSelections else 9),
                            cancelable = false
                        )
                    }

                    override fun autoClose() {
                        if (args.autoDismissOnMaxSelections) {
                            getListAndClose()
                        }
                    }
                }
            )

            rcvSelectPhotos.adapter = adapter
            binding.pbFileLoading.isGone = false
        }
    }

    @ExperimentalCoroutinesApi
    private fun initAction() {
        binding.icClose.clickDebounce {
            dismiss()
            if (isSdk) {
                viewModel.sendListImage(null)
                activity?.finish()
            }
        }

        binding.rlSelected.clickDebounce {
            getListAndClose()
        }

        binding.tvPhotoAndVideo.clickDebounce {
            viewModel.selectedType = MediaType.PHOTO
            binding.rcvSelectPhotos.isVisible = true
            binding.layoutContainMap.isGone = true
            viewModel.reLoadMediaLocal()
            setViewSelected(true, binding.tvPhotoAndVideo)
            setViewSelected(false, binding.tvDocuments)
            setViewSelected(false, binding.tvLocation)
        }

        binding.tvDocuments.clickDebounce {
            viewModel.selectedType = MediaType.FILE
            binding.rcvSelectPhotos.isVisible = true
            binding.layoutContainMap.isGone = true
            viewModel.initListDocumentLocal()
            setViewSelected(false, binding.tvPhotoAndVideo)
            setViewSelected(true, binding.tvDocuments)
            setViewSelected(false, binding.tvLocation)
        }

        binding.tvLocation.clickDebounce {
            binding.rcvSelectPhotos.isGone = true
            binding.layoutContainMap.isVisible = true
            binding.layoutLiveTrip.isVisible = true
            setViewSelected(false, binding.tvPhotoAndVideo)
            setViewSelected(false, binding.tvDocuments)
            setViewSelected(true, binding.tvLocation)
        }
    }

    @ExperimentalCoroutinesApi
    override fun initData() {
        viewModel.isChat = isChat
        viewModel.isLoadFull = LoadType.LOAD_FIRST
        viewModel.selectedType = MediaType.PHOTO
        viewModel.listLocalMediaModel.observeOnce { listLocalMediaFile ->
            binding.pbFileLoading.isGone = true
            binding.rcvSelectPhotos.isVisible = true
            binding.rcvSelectPhotos.layoutManager = GridLayoutManager(requireContext(), 3)
            binding.rcvSelectPhotos.setHasFixedSize(true)
            binding.rcvSelectPhotos.adapter = adapter?.apply {
                setType(MediaType.PHOTO)
                setItems(listLocalMediaFile)
            }
            /*if (viewModel.isLoadFull == LoadType.LOAD_FULL) {
                viewModel.isLoadFull = LoadType.LOAD_DONE
            } else if (viewModel.isLoadFull == LoadType.LOAD_FIRST) {
                viewModel.isLoadFull = LoadType.LOAD_FULL
            }
            syncDataLocal()*/
        }
        viewModel.listLocalDocumentModel.observeOnce { listLocalDocumentFile ->
            binding.pbFileLoading.isGone = true
            binding.rcvSelectPhotos.isVisible = true
            binding.rcvSelectPhotos.layoutManager = LinearLayoutManager(requireContext())
            binding.rcvSelectPhotos.setHasFixedSize(true)
            binding.rcvSelectPhotos.adapter = adapter?.apply {
                setType(MediaType.FILE)
                setItems(listLocalDocumentFile)
            }
        }
    }

    private fun setViewSelected(isSelected: Boolean, selectedView: TextView) {
        // Run in main thread
        MainScope().launch {
            if (isSelected) {
                themeHelperImpl.setThemeColorForViews(selectedView)
                selectedView.setBackgroundResource(R.drawable.bg_reply_message_container_border)
            } else {
                selectedView.setTextColor(
                    ContextCompat.getColor(
                        requireContext(),
                        R.color.color_sub_text_4
                    )
                )
                selectedView.setBackgroundResource(0)
            }
        }
    }

    override fun setupTheme() {
        themeHelperImpl.setThemeColorForViews(binding.rlSelected)
    }

    override fun onResume() {
        super.onResume()
        syncDataLocal()
    }

    private fun syncDataLocal() {
        checkPermissionStorage(
            {
                if (viewModel.isLoadFull != LoadType.LOAD_DONE) {
                    mainSdkViewModel.syncLocalFile(true) {
                        when (viewModel.selectedType) {
                            MediaType.PHOTO, MediaType.VIDEO -> viewModel.initListMediaLocal(it, args.galleryType)
                            MediaType.FILE -> viewModel.initListDocumentLocal()
                            else -> viewModel.initListMediaLocal(it)
                        }
                    }
                }
            },
            {}
        )
    }

    private fun getListAndClose() {
        val listPathSelected = adapter?.getListSelectedPhotos()
        if (listPathSelected.isNotNull) {
            setFragmentResult(SELECT_PHOTO_VIDEO, bundleOf("data" to listPathSelected))
            viewModel.sendListImage(listPathSelected)
        }
        dismiss()
        if (isSdk) {
            activity?.finish()
        }
    }
}
