/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.main.profile

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.base.chat.coroutine.NetAloEvent
import com.netacom.base.chat.livedata.EventLiveData
import com.netacom.full.define.LoadType
import com.netacom.lite.define.GalleryType
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.local.LocalFileModel
import com.netacom.lite.hilt.executor.PostExecutionThread
import com.netacom.lite.local.db.DbManager
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import com.netacom.lite.mapper.LocalFile_Local_DB_Mapper
import dagger.hilt.android.lifecycle.HiltViewModel
import javax.inject.Inject

/**
Created by vietnguyen on 22/Sep/2020
Company: Netacom.
 **/
@HiltViewModel
class SelectMediaViewModel @Inject constructor(
    private val postExecutionThread: PostExecutionThread,
    private val preferencesHelperImpl: PreferencesHelperImpl,
    private val localFileMapper: LocalFile_Local_DB_Mapper,
    private val dbManager: DbManager,
    private val netAloEvent: NetAloEvent
) : BaseViewModel() {
    var isChat: Boolean = true
    var isLoadFull: Int = LoadType.LOAD_FULL
    var selectedType: MediaType = MediaType.PHOTO

    private val _listLocalMediaModel = MutableLiveData<EventLiveData<List<LocalFileModel>>>()
    val listLocalMediaModel: LiveData<EventLiveData<List<LocalFileModel>>> = _listLocalMediaModel

    private val _listLocalDocumentModel = MutableLiveData<EventLiveData<List<LocalFileModel>>>()
    val listLocalDocumentModel: LiveData<EventLiveData<List<LocalFileModel>>> = _listLocalDocumentModel

    fun appId() = preferencesHelperImpl.sdkConfig?.appId

    fun getAvatar() = preferencesHelperImpl.user?.getDisplayAvatar

    fun reLoadMediaLocal() {
        _listLocalMediaModel.value?.peekContent()?.apply {
            _listLocalMediaModel.post(EventLiveData(this))
        }
    }

    fun initListMediaLocal(localList: List<LocalFileModel>, galleryType: Long = GalleryType.GALLERY_ALL) {
        launchOnViewModelScope(postExecutionThread.io) {
            val newList = mutableListOf<LocalFileModel>()
            newList.add(0, LocalFileModel(fileName = MediaType.CAMERA.name, filePath = MediaType.CAMERA.name, fileType = MediaType.PHOTO, fileSize = 0))
            when (galleryType) {
                GalleryType.GALLERY_ALL -> newList.addAll(localList)
                GalleryType.GALLERY_PHOTO -> newList.addAll(localList.filter { it.fileType == MediaType.PHOTO })
                GalleryType.GALLERY_VIDEO -> newList.addAll(localList.filter { it.fileType == MediaType.VIDEO })
            }
            _listLocalMediaModel.post(EventLiveData(newList))
        }
    }

    fun initListDocumentLocal() {
        launchOnViewModelScope(postExecutionThread.io) {
            _listLocalDocumentModel.post(EventLiveData(getListDocumentFileFromDB()))
        }
    }

    private suspend fun getListDocumentFileFromDB(): ArrayList<LocalFileModel> =
        ArrayList(localFileMapper.mapFromDomainList(dbManager.getListLocalFileByType(MediaType.FILE.ordinal)))

    fun sendListImage(listLocalFile: List<LocalFileModel>?) {
        launchOnViewModelScope(postExecutionThread.io) {
            netAloEvent.send(listLocalFile)
        }
    }

    fun sendListFile(localFile: LocalFileModel?) {
        launchOnViewModelScope(postExecutionThread.io) {
            netAloEvent.send(localFile)
        }
    }
}
