package com.netacom.full.ui.main.profile.adapter

import android.view.View
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.getThemeColor
import com.netacom.full.R
import com.netacom.full.databinding.ItemBlockListBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.BlockedItem

class BlockedListAdapter(
    val unBlockClick: ((BlockedItem, View, Int) -> Unit),
    private val themeHelperImpl: ThemeHelperImpl
) : BaseListSimpleAdapter<BlockedItem, ItemBlockListBinding>(unBlockClick, diff = DiffCallBack()) {
    override fun bind(item: BlockedItem, holder: BaseViewHolder<ItemBlockListBinding>, position: Int) {
        with(holder.binding) {
            imgAvatar.setImageDrawable(null)
            this.item = item
            themeHelperImpl.setThemeColorForSubBackground(btnUnlock)
            btnUnlock.setTextColor(getThemeColor(themeHelperImpl.mainColor))
            btnUnlock.clickDebounce {
                unBlockClick.invoke(item, holder.itemView, position)
            }
        }
    }

    override val layout: Int
        get() = R.layout.item_block_list

    private class DiffCallBack : DiffUtil.ItemCallback<BlockedItem>() {

        override fun areItemsTheSame(oldItem: BlockedItem, newItem: BlockedItem): Boolean {
            return oldItem.neUser.id == newItem.neUser.id
        }

        override fun areContentsTheSame(oldItem: BlockedItem, newItem: BlockedItem): Boolean {
            return oldItem == newItem
        }
    }
}
