/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.android_utils.TimeUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.ItemPhotoBinding
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.local.LocalFileModel

class MediaViewHolder(private val mediaItemHolder: ItemPhotoBinding) : BaseViewHolder<ItemPhotoBinding>(mediaItemHolder) {
    private var localFileModel: LocalFileModel? = null
    private var mediaCallBackAction: SelectedMediaAction? = null

    fun bind(
        pathItem: LocalFileModel?,
        type: MediaType,
        callBack: SelectedMediaAction
    ) {
        localFileModel = pathItem
        mediaCallBackAction = callBack
        with(mediaItemHolder) {
            if (type == MediaType.FILE) {
                tvMediaDuration.isGone = true
                imgPhoto.isGone = true
                groupFile.isVisible = true
                doShowDocument()
            } else {
                groupFile.isGone = true
                imgPhoto.isVisible = true
                localFileModel?.let {
                    when (it.fileType) {
                        MediaType.PHOTO -> doShowPhoto()
                        MediaType.VIDEO -> doShowVideo()
                        else -> MediaType.PHOTO
                    }
                }
            }
        }
    }

    fun bindCamera() {
        with(mediaItemHolder) {
            groupFile.isGone = true
            imgPhoto.isVisible = true
            tvMediaDuration.isGone = true
            imgPhoto.setImageDrawable(ContextCompat.getDrawable(Utils.getApp(), R.drawable.ic_photo_camera_white))
        }
    }

    companion object {
        fun create(parent: ViewGroup): MediaViewHolder {
            val binding = DataBindingUtil.inflate<ItemPhotoBinding>(
                LayoutInflater.from(parent.context),
                R.layout.item_photo,
                parent,
                false
            )
            return MediaViewHolder(binding)
        }
    }

    fun setItemSelectUnSelect(localFileModel: LocalFileModel?) {
        localFileModel?.let {
            with(mediaItemHolder.imgCount) {
                isVisible = it.index > 0
                text = it.index.toString()
            }
        }
    }

    private fun doShowPhoto() {
        with(mediaItemHolder) {
            imgPhoto.isVisible = true
            tvMediaDuration.isGone = true
            localFileModel?.let { localFile ->
                imgPhoto.loadImage(
                    imgUrl = localFile.filePath,
                    corner = 2f,
                    allowCenterCrop = true
                )
                itemView.clickDebounce {
                    mediaCallBackAction?.selectedMediaAction(localFile.index == 0, layoutPosition, localFile)
                }
            }
        }
    }

    private fun doShowVideo() {
        with(mediaItemHolder) {
            imgPhoto.isVisible = true
            tvMediaDuration.isVisible = true
            localFileModel?.let { localFile ->
                imgPhoto.loadImage(imgUrl = localFile.filePath, allowCenterCrop = true)
                tvMediaDuration.text = TimeUtils.second2String(localFile.fileDuration)
                itemView.clickDebounce {
                    mediaCallBackAction?.selectedMediaAction(localFile.index == 0, layoutPosition, localFile)
                }
            }
        }
    }

    private fun doShowDocument() {
        localFileModel?.let { localFile ->
            with(mediaItemHolder) {
                tvFileName.text = localFile.fileName
                tvFileDescription.text = localFile.fileSizeText
                itemView.clickDebounce {
                    mediaCallBackAction?.selectedDocumentAction(layoutPosition, localFile)
                }
            }
        }
    }
}
