/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.profile.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseListAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.isNotNull
import com.netacom.full.R
import com.netacom.full.databinding.ItemPhotoBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.define.MediaType
import com.netacom.lite.entity.ui.local.LocalFileModel

class SelectMediaAdapter(
    private val themeHelperImpl: ThemeHelperImpl? = null,
    private val maxSelections: Long
) : BaseListAdapter<LocalFileModel, ItemPhotoBinding>(
    diffCallback = SelectMediaDiff()
) {
    private var callbackToParent: SelectPhotoAction? = null
    private var selectedItemCount = 0
    private var indexUnSelect = 0
    private var mediaType: MediaType = MediaType.PHOTO

    override fun getItemCount(): Int {
        return getData.size
    }

    private class SelectMediaDiff : DiffUtil.ItemCallback<LocalFileModel>() {
        override fun areItemsTheSame(oldItem: LocalFileModel, newItem: LocalFileModel): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(oldItem: LocalFileModel, newItem: LocalFileModel): Boolean {
            return oldItem.filePath == newItem.filePath && oldItem.fileType == newItem.fileType && oldItem.fileName == newItem.fileName && oldItem.fileSize == newItem.fileSize
        }
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): BaseViewHolder<ItemPhotoBinding> {
        return MediaViewHolder(
            DataBindingUtil.inflate(
                LayoutInflater.from(parent.context),
                R.layout.item_photo,
                parent,
                false
            )
        )
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ItemPhotoBinding>, position: Int) {
        val item = getItem(position)
        if (mediaType == MediaType.FILE) {
            if (item?.filePath.isNotNull) {
                (holder as MediaViewHolder).bind(
                    pathItem = item,
                    type = mediaType,
                    callBack = object : SelectedMediaAction {
                        override fun selectedDocumentAction(
                            position: Int,
                            item: LocalFileModel
                        ) {
                            callbackToParent?.onSelectedDocument(item)
                        }
                    }
                )
            }
            themeHelperImpl?.setThemeColorForViews(holder.binding.imgFile)
        } else {
            if (item?.filePath.isNotNull) {
                if (position == 0 || item?.filePath == MediaType.CAMERA.name) {
                    (holder as MediaViewHolder).bindCamera()
                    holder.itemView.clickDebounce {
                        callbackToParent?.onOpenCamera()
                    }
                } else {
                    (holder as MediaViewHolder).bind(
                        pathItem = item,
                        type = mediaType,
                        callBack = object : SelectedMediaAction {
                            override fun selectedMediaAction(isSelected: Boolean, position: Int, item: LocalFileModel) {
                                if (isSelected) {
                                    if (selectedItemCount < 9 && (maxSelections > 0 && selectedItemCount < maxSelections)) {
                                        selectedItemCount++
                                        item.index = selectedItemCount
                                        holder.setItemSelectUnSelect(item)
                                        if (maxSelections > 0 && selectedItemCount.toLong() == maxSelections) {
                                            callbackToParent?.autoClose()
                                        }
                                    } else {
                                        callbackToParent?.selectFull()
                                    }
                                } else {
                                    indexUnSelect = item.index
                                    selectedItemCount--
                                    item.index = 0
                                    holder.setItemSelectUnSelect(item)
                                    getData.mapIndexed { index, localFileModel ->
                                        if (localFileModel.index > 0 && localFileModel.index > indexUnSelect) {
                                            localFileModel.index--
                                            notifyItemChanged(index, localFileModel)
                                        }
                                    }
                                }
                                callbackToParent?.updateCount(selectedItemCount)
                            }
                        }
                    )
                    holder.setItemSelectUnSelect(item)
                }
            }
        }
    }

    fun setItems(items: List<LocalFileModel>) {
        display(items)
    }

    fun setType(type: MediaType) {
        mediaType = type
    }

    fun getListSelectedPhotos(): List<LocalFileModel> {
        return getData.filter { it.index > 0 }
    }

    fun setParentCallback(callback: SelectPhotoAction) {
        callbackToParent = callback
    }
}
