/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.theme

import androidx.navigation.NavController
import com.netacom.base.chat.base.BaseViewModel
import com.netacom.full.dispatchers.Dispatcher
import com.netacom.lite.local.prefs.PreferencesHelperImpl
import com.netacom.lite.sdk.AppID
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.ExperimentalCoroutinesApi
import javax.inject.Inject

@ExperimentalCoroutinesApi
@HiltViewModel
class ThemeViewModel @Inject constructor(
    private val preferencesHelperImpl: PreferencesHelperImpl,
    private val navigationDispatcher: Dispatcher<(NavController) -> Unit>
) : BaseViewModel() {

    fun appId() = preferencesHelperImpl.sdkConfig?.appId ?: AppID.NETALO_PROD

    fun onBack() {
        navigationDispatcher.emit {
            it.popBackStack()
        }
    }
}
