/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.main.theme.adapter

import android.content.Context
import android.view.View
import android.widget.RadioButton
import com.netacom.base.chat.adapter.BaseSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.resIdByNameColor
import com.netacom.base.chat.util.resNameById
import com.netacom.full.R
import com.netacom.full.databinding.ItemColorThemeBinding
import com.netacom.full.databinding.setBackgroundColorTheme
import com.netacom.full.databinding.setRadioButtonColorTheme
import com.netacom.lite.entity.ui.theme.NeTheme
import com.netacom.lite.sdk.AppID

class ColorAdapter(
    context: Context,
    itemClick: ((NeTheme, View, Int) -> Unit)?,
    private val appId: Int,
    private val mainColorStorage: Int
) : BaseSimpleAdapter<NeTheme, ItemColorThemeBinding>(itemClick) {

    init {
        if (appId == AppID.GALO) {
            data.add(
                NeTheme(
                    mainColor = context.resNameById(R.color.color_green_gchat),
                    menuColor = context.resNameById(R.color.bottom_navigation_menu_green),
                    subColor = context.resNameById(R.color.color_green_sub_gchat),
                    toolbarDrawable = context.resNameById(R.color.color_green_gchat),
                    isDefaultColor = true,
                    colorIdReferral = context.resNameById(R.drawable.ic_bg_referral_code_orange)
                )
            )
        } else {
            data.add(
                NeTheme(
                    mainColor = context.resNameById(R.color.color_orange_f5783f),
                    menuColor = context.resNameById(R.color.bottom_navigation_menu_orange),
                    subColor = context.resNameById(R.color.color_orange_4df5783f),
                    toolbarDrawable = context.resNameById(R.drawable.bg_header_orange),
                    isDefaultColor = true,
                    colorIdReferral = context.resNameById(R.drawable.ic_bg_referral_code_orange)
                )
            )
            data.add(
                NeTheme(
                    mainColor = context.resNameById(R.color.color_blue_00a8d6),
                    menuColor = context.resNameById(R.color.bottom_navigation_menu_blue),
                    subColor = context.resNameById(R.color.color_blue_4d00a8d6),
                    toolbarDrawable = context.resNameById(R.drawable.bg_header),
                    colorIdReferral = context.resNameById(R.drawable.ic_bg_referral_code_blue)
                )
            )
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ItemColorThemeBinding>, position: Int) {
        val item = data[position]
        itemClick?.let { click ->
            holder.itemView.clickDebounce {
                selectedPosition = position
                applyColorRadioBtn(holder.binding.rdBtnColor, holder.binding.root.context)
                click.invoke(item, holder.itemView, position)
                notifyDataSetChanged()
            }
        }
        bind(item, holder, position)
        holder.binding.executePendingBindings()
    }

    override val layout: Int
        get() = R.layout.item_color_theme

    override fun bind(item: NeTheme, holder: BaseViewHolder<ItemColorThemeBinding>, position: Int) {
        holder.binding.apply {

            imgColor.setBackgroundColorTheme(root.context.resIdByNameColor(item.mainColor))
            rdBtnColor.setRadioButtonColorTheme(root.context.resIdByNameColor(item.mainColor))
            // If have stored drawable background name, use it
            if (selectedPosition == -1 && root.context.resIdByNameColor(item.mainColor) == mainColorStorage) {
                rdBtnColor.isChecked = true
                rdBtnColor.setRadioButtonColorTheme(mainColorStorage)
                imgColor.setBackgroundResource(R.drawable.two_circle_bg)
                imgColor.setImageResource(R.drawable.ic_single_check_white)
            } else {
                rdBtnColor.isChecked = selectedPosition == position
            }
            if (!rdBtnColor.isChecked) {
                imgColor.setBackgroundResource(R.drawable.bg_cicle_color_blue_1b)
                imgColor.setImageResource(android.R.color.transparent)
            } else {
                imgColor.setBackgroundResource(R.drawable.two_circle_bg)
                imgColor.setImageResource(R.drawable.ic_single_check_white)
            }
        }
    }

    private fun applyColorRadioBtn(radioButton: RadioButton, context: Context) {
        radioButton.setRadioButtonColorTheme(
            context.resIdByNameColor(data[selectedPosition].mainColor)
        )
    }
}
