/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.sdk

import android.app.Application
import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatDelegate
import androidx.fragment.app.FragmentActivity
import com.facebook.stetho.Stetho
import com.google.android.gms.common.GoogleApiAvailability
import com.google.android.gms.security.ProviderInstaller
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.AppUtils
import com.netacom.base.chat.android_utils.CrashUtils
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.app.isProduction
import com.netacom.base.chat.app.isShowLog
import com.netacom.base.chat.coroutine.NetAloEvent
import com.netacom.base.chat.logger.AndroidLogAdapter
import com.netacom.base.chat.logger.FormatStrategy
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.logger.PrettyFormatStrategy
import com.netacom.base.chat.network.ResultData
import com.netacom.full.BuildConfig
import com.netacom.full.utils.ThemeUtils
import com.netacom.lite.define.GalleryType
import com.netacom.lite.entity.socket.Call
import com.netacom.lite.entity.ui.theme.NeTheme
import com.netacom.lite.entity.ui.user.NeUser
import com.netacom.lite.network.model.response.SettingResponse
import com.netacom.lite.sdk.SdkConfig
import com.netacom.lite.socket.request.BlockUserRequest
import com.netacom.lite.util.CallbackResult
import io.sentry.android.core.SentryAndroid
import io.sentry.android.core.SentryAndroidOptions
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
Created by toanmobile on 19,NOV,2020
Company: Netacom.
Email: hvtoan.dev@gmail.com
 */

object NetAloSDK {

    @Volatile
    var fragmentDisplay: String? = null

    @Volatile
    var activeGroup: String? = null
    val netAloEvent: NetAloEvent? get() = if (::sdkNetAloCore.isInitialized) sdkNetAloCore.netAloEvent else null
    private lateinit var sdkNetAloCore: SdkCore

    fun initNetAloSDK(context: Application, sdkCore: SdkCore, sdkConfig: SdkConfig, neTheme: NeTheme? = null) {
        this.sdkNetAloCore = sdkCore
        if (::sdkNetAloCore.isInitialized) {
            ThemeUtils.isDarkModeInSystem = ThemeUtils.isOsDarkTheme(context)
            ThemeUtils.enableDisplayMode(sdkCore.themeHelperImpl.displayMode)
            ProviderInstaller.installIfNeededAsync(
                context,
                object : ProviderInstaller.ProviderInstallListener {
                    override fun onProviderInstalled() {
                    }

                    override fun onProviderInstallFailed(errorCode: Int, recoveryIntent: Intent?) {
                        GoogleApiAvailability.getInstance().showErrorNotification(context, errorCode)
                    }
                }
            )
            SentryAndroid.init(context) { options: SentryAndroidOptions ->
                options.dsn = "http://26d10fdab3674b20a8d54650b2777599@sentry.netalo.vn:9000/5"
                options.isEnableSessionTracking = isProduction
                options.isAnrReportInDebug = isProduction
                options.release = AppUtils.getAppVersionName()
                options.environment = BuildConfig.FLAVOR
            }
            Utils.init(context)
            AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
            CrashUtils.init { crashInfo ->
                Logger.d("CrashUtils=$crashInfo")
                if (isProduction) AppUtils.relaunchApp()
            }
            val formatStrategy: FormatStrategy = PrettyFormatStrategy.newBuilder()
                .tag("NetacomSDK")
                .build()
            Logger.addLogAdapter(
                object : AndroidLogAdapter(formatStrategy) {
                    override fun isLoggable(priority: Int, tag: String?): Boolean {
                        return isShowLog
                    }
                }
            )
            if (!isProduction) {
                Stetho.initializeWithDefaults(context)
            }
            sdkNetAloCore.socketRepository.apply {
                CoroutineScope(getPostExecutionThread.io).launch {
                    getPreferences.apply {
                        this.sdkConfig = sdkConfig
                        this.neTheme = neTheme
                        this.setting = SettingResponse(cdnEndpoint = sdkConfig.cdnEndpoint)
                        Logger.e("sdkConfig==${this.sdkConfig}\n" + "neTheme==${this.neTheme}" + "setting=$setting")
                    }
                }
            }
        }
    }

    fun initTheme(neTheme: NeTheme? = null) {
        if (::sdkNetAloCore.isInitialized && neTheme != null) {
            sdkNetAloCore.socketRepository.apply {
                CoroutineScope(getPostExecutionThread.io).launch {
                    getPreferences.apply {
                        this.neTheme = neTheme
                        Logger.e("sdkConfig==${this.sdkConfig}\n" + "neTheme==${this.neTheme}")
                    }
                }
            }
        }
    }

    fun initSetting(settingResponse: SettingResponse? = null) {
        if (::sdkNetAloCore.isInitialized && settingResponse != null) {
            sdkNetAloCore.socketRepository.apply {
                CoroutineScope(getPostExecutionThread.io).launch {
                    getPreferences.apply {
                        this.setting = settingResponse
                        Logger.e("setting==$setting")
                    }
                }
            }
        }
    }

    fun initPermission(activity: FragmentActivity) {
        NetAloActivity.initPermission(activity)
    }

    fun setNetAloUser(neUser: NeUser? = null) {
        if (::sdkNetAloCore.isInitialized) {
            sdkNetAloCore.socketRepository.apply {
                CoroutineScope(getPostExecutionThread.io).launch {
                    getPreferences.apply {
                        this.user = neUser
                        Logger.e("setNetAloUser:isInitialized:${this.user}")
                        getIOSocket.connectSocket(
                            { socketConnect ->
                                Logger.e("connectSocket==$socketConnect")
                                // TODO ioSocketLite.disConnectSocket()
                            },
                            isSdk = true
                        )
                        sdkNetAloCore.socketMessage()
                    }
                }
            }
        }
    }

    fun openNetAlo(context: Context, neUserChat: NeUser? = null, call: Call? = null, isNotification: Boolean = false) {
        NetAloActivity.startSDK(
            context = context,
            neUserChat = neUserChat,
            call = call,
            isNotification = isNotification
        )
    }

    fun openNetAloSDK(context: Context, neUserChat: NeUser? = null) {
        NetAloActivity.startSDK(
            context = context,
            neUserChat = neUserChat,
            isSdk = true
        )
    }

    fun eventFireBase(data: Map<String, String>) {
        if (::sdkNetAloCore.isInitialized) {
            netAloEvent?.apply {
                send(data)
            }
        }
    }

    fun openGallery(context: Context, isShowDocumented: Boolean = false, maxSelections: Int, autoDismissOnMaxSelections: Boolean, galleryType: Long = GalleryType.GALLERY_ALL) {
        NetAloActivity.startGallery(
            context = context,
            isShowDocumented = isShowDocumented,
            maxSelections = maxSelections,
            autoDismissOnMaxSelections = autoDismissOnMaxSelections,
            galleryType = galleryType
        )
    }

    fun exitSDK() {
        if (::sdkNetAloCore.isInitialized) {
            sdkNetAloCore.socketRepository.apply {
                getIOSocket.disConnectSocket()
            }
        }
    }

    fun blockUser(userId: Long? = 0L, isBlock: Boolean = true, callbackResult: CallbackResult<Boolean>) {
        if (userId == 0L) return
        if (::sdkNetAloCore.isInitialized) {
            sdkNetAloCore.socketRepository.apply {
                CoroutineScope(getPostExecutionThread.io).launch {
                    val groupId = getDbManager.findGroupByBlock(userId)
                    val blockUserRequest = BlockUserRequest(groupId = groupId, blockedUins = userId)
                    if (isBlock) {
                        getIOSocket.blockUser(blockUserRequest).let { result ->
                            when (result) {
                                is ResultData.Success -> result.data?.let { success ->
                                    if (success) {
                                        sdkNetAloCore.groupRepository.updateBlockUsers(mutableListOf(userId ?: 0L), groupId)?.apply {
                                            withContext(getPostExecutionThread.main) {
                                                Logger.e("blockUser:callBackSuccess")
                                                callbackResult.callBackSuccess(true)
                                            }
                                        }
                                    } else {
                                        withContext(getPostExecutionThread.main) {
                                            Logger.e("blockUser:callBackError${result.data}")
                                            callbackResult.callBackError(result.data.toString())
                                        }
                                    }
                                }
                                is ResultData.Failed -> {
                                    withContext(getPostExecutionThread.main) {
                                        Logger.e("blockUser:callBackError${result.message}")
                                        callbackResult.callBackError(result.message)
                                    }
                                }
                                else -> {
                                }
                            }
                        }
                    } else {
                        getIOSocket.unBlockUser(blockUserRequest).let { result ->
                            when (result) {
                                is ResultData.Success -> result.data?.let { success ->
                                    if (success) {
                                        sdkNetAloCore.groupRepository.updateUnblockUsers(mutableListOf(userId ?: 0L), groupId)?.apply {
                                            withContext(getPostExecutionThread.main) {
                                                Logger.e("unBlockUser:callBackSuccess")
                                                callbackResult.callBackSuccess(true)
                                            }
                                        }
                                    } else {
                                        withContext(getPostExecutionThread.main) {
                                            Logger.e("unBlockUser:callBackError${result.data}")
                                            callbackResult.callBackError(result.data.toString())
                                        }
                                    }
                                }
                                is ResultData.Failed -> {
                                    withContext(getPostExecutionThread.main) {
                                        Logger.e("unBlockUser:callBackError${result.message}")
                                        callbackResult.callBackError(result.message)
                                    }
                                }
                                else -> {
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    fun getListContactFromServer(callbackSuccess: (List<NeUser>) -> Unit?) {
        try {
            // mainSdkViewModel.syncContact(SyncType.LIST_SYNC_SERVER, isSyncContact = true, callbackSuccess)
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }

    fun getListContactLocal(callbackSuccess: (List<NeUser>) -> Unit?) {
        try {
            // mainSdkViewModel.syncContact(SyncType.LIST_SYNC_SERVER, isSyncContact = true, callbackSuccess)
        } catch (e: Exception) {
            e.printStackTrace()
            FirebaseCrashlytics.getInstance().recordException(e)
        }
    }
}
