/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.ui.sdk

import androidx.core.os.bundleOf
import androidx.navigation.findNavController
import com.netacom.base.chat.base.BaseActivity
import com.netacom.full.R
import dagger.hilt.android.AndroidEntryPoint

/**
Created by vantoan on 08,Apr,2021
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 */
@AndroidEntryPoint
class SdkActivity : BaseActivity(R.layout.activity_sdk) {

    private val navController by lazy {
        findNavController(R.id.nav_sdk)
    }

    override fun initViews() {
        intent.extras?.apply {
            val graph = navController.navInflater.inflate(R.navigation.nav_sdk)
            val bundle = bundleOf("isShowDocumented" to getBoolean("isShowDocumented"), "maxSelections" to getInt("maxSelections").toLong(), "autoDismissOnMaxSelections" to getBoolean("autoDismissOnMaxSelections"), "galleryType" to getLong("galleryType"))
            navController.setGraph(graph, bundle)
        }
    }

    override fun initData() {
    }
}
