/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.ui.sdk

import androidx.hilt.work.HiltWorkerFactory
import androidx.work.WorkManager
import androidx.work.workDataOf
import com.netacom.base.chat.android_utils.Utils
import com.netacom.base.chat.coroutine.NetAloEvent
import com.netacom.base.chat.logger.Logger
import com.netacom.base.chat.network.BaseRepository
import com.netacom.full.extensions.enqueueOneTimeNetworkWorkRequest
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.full.worker.message.MessageWorker
import com.netacom.lite.define.FirebaseDefine
import com.netacom.lite.repository.GroupRepository
import com.netacom.lite.repository.MessageRepository
import com.netacom.lite.repository.SocketRepository
import kotlinx.coroutines.flow.collect
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class SdkCore @Inject constructor(
    private val socketRepositoryHelp: SocketRepository,
    private val messageRepository: MessageRepository,
    private val groupRepositoryHelp: GroupRepository,
    private val themeHelperImplHelp: ThemeHelperImpl,
    private val workerFactoryHelp: HiltWorkerFactory,
    private val event: NetAloEvent
) : BaseRepository() {

    val workerFactory get() = workerFactoryHelp

    val themeHelperImpl get() = themeHelperImplHelp

    val socketRepository get() = socketRepositoryHelp

    val groupRepository get() = groupRepositoryHelp

    val netAloEvent get() = event

    suspend fun socketMessage() {
        socketRepository.getIOSocket.flowMessage.collect { message ->
            message?.apply {
                val dbMessageEntity = messageRepository.mapMessageSKToDb(message = this)
                val neMessage = messageRepository.mapMessageDBToUi(dbMessageEntity = dbMessageEntity)
                Logger.e("sdk:hahaha:socketMessage:neMessage=$neMessage")
                // Handle message with status received or seen
                WorkManager.getInstance(Utils.getApp()).enqueueOneTimeNetworkWorkRequest<MessageWorker>(
                    workDataOf(FirebaseDefine.KEY_DATA to messageRepository.mapMessageToFcm(neMessage))
                )
                socketRepository.getIOSocket.flowMessage.value = null
            }
        }
    }
}
