package com.netacom.full.utils

import com.netacom.lite.entity.database.attachment.NeDocument
import com.netacom.lite.entity.database.attachment.NeLocation
import com.netacom.lite.entity.database.attachment.NeVideo
import com.netacom.lite.entity.ui.message.NeAudio
import com.netacom.lite.entity.ui.message.NeMessage

/**
 * Create on 7/29/20
 * @author duonghd
 */

interface AbstractItemClickListener {
    fun onReplyClicked(messageId: String) {}

    fun onCallClicked(messageInfo: NeMessage?, isVoice: Boolean) {}

    fun onDisplayImage(
        imageUrls: List<String>,
        imageClickedPos: Int,
        isLocalLink: Boolean = false,
        messageId: String? = null
    ) {}

    fun onViewVideo(neVideo: NeVideo, itemClickedPos: Int) {}

    fun onDocumentAction(messageId: String?, docItem: NeDocument, itemClickedPos: Int, isDownload: Boolean = false) {}

    fun onLocationClick(neLocation: NeLocation, neMessage: NeMessage) {}

    fun onLongItemClick(neMessage: NeMessage) {}

    fun onAudioClick(messageId: String?, relatedMessageId: String?, audio: NeAudio, itemClickedPos: Int)
}
