/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

@file:Suppress("DEPRECATION")

package com.netacom.full.utils

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.Window
import android.widget.ImageView
import android.widget.TextView
import androidx.annotation.StringRes
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.widget.AppCompatButton
import androidx.appcompat.widget.AppCompatImageView
import androidx.core.view.isGone
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.ScreenUtils
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.ui.main.theme.ThemeHelperImpl

/**
 * Global functions for show Dialog (update version com.netacom.com.netacom.base.chat.app, pick, ...)
 */
class DialogUtil {
    companion object {
        @JvmStatic
        fun showLogOutConfirm(context: Context, callback: (Unit) -> Unit, themeHelperImpl: ThemeHelperImpl? = null) =
            show(
                context = context,
                messageRes = R.string.popup_confirm_logout,
                okLabel = R.string.popup_confirm_logout_ok,
                okFunc = callback,
                cancelLabel = R.string.popup_confirm_logout_no,
                cancelable = true,
                themeHelperImpl = themeHelperImpl
            )

        fun showError(
            context: Context?,
            @StringRes message: Int? = null,
            @StringRes title: Int? = null,
            messageString: String? = null,
            cancelable: Boolean = false,
            retryFunc: ((Unit) -> Unit)? = null
        ): Unit? {
            if (context == null) return null
            val builder = AlertDialog.Builder(context)
            val dialogView: View = LayoutInflater.from(context).inflate(
                R.layout.dialog_common,
                null
            )
            builder.setView(dialogView)
            val alertDialog = builder.create()
            with(dialogView) {
                alertDialog.setCanceledOnTouchOutside(cancelable)
                findViewById<AppCompatButton>(R.id.btnCancel)?.isGone = true
                // findViewById<ImageView>(R.id.imgIcon)?.setImageDrawable(context.getDrawable(R.drawable.ic_dialog_check_error))
                title?.let { findViewById<TextView>(R.id.tvTitle)?.text = StringUtils.getString(it) } ?: run {
                    isGone = true
                }
                message?.let { findViewById<TextView>(R.id.tvMessage)?.text = StringUtils.getString(it) } ?: messageString?.let { findViewById<TextView>(R.id.tvMessage)?.text = it }
                retryFunc?.let { _ ->
                    findViewById<AppCompatButton>(R.id.btnOK)?.setOnClickListener {
                        alertDialog.dismiss()
                        retryFunc.invoke(Unit)
                    }
                } ?: run {
                    findViewById<AppCompatButton>(R.id.btnOK)?.setOnClickListener {
                        alertDialog.dismiss()
                    }
                }
            }
            return alertDialog.show()
        }

        @JvmStatic
        fun show(
            context: Context,
            @StringRes titleRes: Int? = null,
            @StringRes messageRes: Int? = null,
            @StringRes okLabel: Int? = null,
            @StringRes cancelLabel: Int? = null,
            titleStr: String? = null,
            messageStr: String? = null,
            okFunc: ((Unit) -> Unit)? = null,
            cancelFunc: ((Unit) -> Unit)? = null,
            cancelable: Boolean = true,
            themeHelperImpl: ThemeHelperImpl? = null,
            logoBitmap: Bitmap? = null,
            ignoreOkDismiss: Boolean = false
        ) {
            val builder = AlertDialog.Builder(context, R.style.dialogStyle)

            val dialogView: View = LayoutInflater.from(context).inflate(
                R.layout.dialog_common,
                null
            )
            try {

                themeHelperImpl?.setThemeColorForViews(dialogView.findViewById<AppCompatButton>(R.id.btnOK))
            } catch (e: Exception) {
                FirebaseCrashlytics.getInstance().recordException(e)
                e.printStackTrace()
            }
            builder.setView(dialogView)
            val alertDialog = builder.create()
            with(dialogView) {
                logoBitmap?.let { bitmap ->
                    findViewById<ImageView>(R.id.imgLogo).setImageBitmap(bitmap)
                }
                alertDialog.setCanceledOnTouchOutside(cancelable)
                titleRes?.let { findViewById<TextView>(R.id.tvTitle)?.text = StringUtils.getString(it) } ?: run {
                    titleStr?.let {
                        findViewById<TextView>(R.id.tvTitle)?.text = titleStr
                    }
                }
                messageRes?.let {
                    findViewById<TextView>(R.id.tvMessage)?.text = StringUtils.getString(it)
                } ?: run {
                    messageStr?.let {
                        findViewById<TextView>(R.id.tvMessage)?.text = messageStr
                    }
                }
                okLabel?.let {
                    findViewById<AppCompatButton>(R.id.btnOK)?.apply {
                        text = StringUtils.getString(it)
                        setOnClickListener {
                            if (!ignoreOkDismiss) {
                                alertDialog.dismiss()
                            }
                            okFunc?.invoke(Unit)
                        }
                    }
                } ?: run {
                    findViewById<AppCompatButton>(R.id.btnOK)?.isGone = true
                }
                cancelLabel?.let {
                    findViewById<AppCompatButton>(R.id.btnCancel)?.apply {
                        text = StringUtils.getString(it)
                        setOnClickListener {
                            alertDialog.dismiss()
                            cancelFunc?.invoke(Unit)
                        }
                    }
                } ?: run {
                    findViewById<AppCompatButton>(R.id.btnCancel)?.isGone = true
                }
            }
            return alertDialog.show()
        }

        @JvmStatic
        fun showMessage(
            context: Context?,
            @StringRes title: Int? = null,
            @StringRes message: Int? = null,
            @StringRes okLabel: Int? = null,
            @StringRes cancelLabel: Int? = null,
            okFunc: ((Unit) -> Unit)? = null,
            cancelFunc: ((Unit) -> Unit)? = null,
            cancelable: Boolean = true,
            okButtonIsGone: Boolean = true,
            cancelButtonIsGone: Boolean = false,
            themeHelperImpl: ThemeHelperImpl? = null
        ): Unit? {
            if (context == null) return null
            val builder = AlertDialog.Builder(context, R.style.dialogStyle)
            val dialogView: View = LayoutInflater.from(context).inflate(
                R.layout.dialog_common,
                null
            )
            try {
                themeHelperImpl?.setThemeColorForViews(dialogView.findViewById<AppCompatButton>(R.id.btnOK))
            } catch (e: Exception) {
                FirebaseCrashlytics.getInstance().recordException(e)
                e.printStackTrace()
            }
            builder.setView(dialogView)
            val alertDialog = builder.create()
            with(dialogView) {
                alertDialog.setCanceledOnTouchOutside(cancelable)
                title?.let { findViewById<TextView>(R.id.tvTitle)?.text = StringUtils.getString(it) }
                message?.let { findViewById<TextView>(R.id.tvMessage)?.text = StringUtils.getString(it) }
                okLabel?.let {
                    findViewById<AppCompatButton>(R.id.btnOK)?.setOnClickListener {
                        alertDialog.dismiss()
                        okFunc?.invoke(Unit)
                    }
                } ?: run {
                    findViewById<AppCompatButton>(R.id.btnOK)?.isGone = okButtonIsGone
                }
                cancelLabel?.let {
                    findViewById<AppCompatButton>(R.id.btnCancel)?.apply {
                        text = StringUtils.getString(it)
                        setOnClickListener {
                            alertDialog.dismiss()
                            cancelFunc?.invoke(Unit)
                        }
                    }
                } ?: run {
                    findViewById<AppCompatButton>(R.id.btnCancel)?.isGone = cancelButtonIsGone
                    findViewById<AppCompatButton>(R.id.btnCancel)?.setOnClickListener {
                        alertDialog.dismiss()
                    }
                }
            }
            return alertDialog.show()
        }

        fun showImage(
            context: Context?,
            imageUrl: String?,
            okFunc: ((AlertDialog) -> Unit),
            cancelFunc: (() -> Unit)
        ): Unit? {
            if (context == null) return null
            var isClickOK = false
            val builder = AlertDialog.Builder(context, R.style.dialogStyleImage)
            val dialogView: View = LayoutInflater.from(context).inflate(
                R.layout.dialog_image,
                null
            )
            builder.setView(dialogView)
            val alertDialog = builder.create()
            with(dialogView) {
                alertDialog.setCanceledOnTouchOutside(true)
                alertDialog.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
                alertDialog.window?.requestFeature(Window.FEATURE_NO_TITLE)
                minimumWidth = ScreenUtils.getScreenWidth() - resources.getDimensionPixelSize(R.dimen.dp_60)
                minimumHeight = ScreenUtils.getScreenHeight() / 2 - resources.getDimensionPixelSize(R.dimen.dp_60)
                findViewById<AppCompatImageView>(R.id.imgFull)?.apply {
                    loadImage(imageUrl)
                    setOnClickListener {
                        isClickOK = true
                        alertDialog.dismiss()
                        okFunc(alertDialog)
                    }
                }
                findViewById<AppCompatImageView>(R.id.btnClose)?.setOnClickListener {
                    alertDialog.dismiss()
                }
                alertDialog.setOnDismissListener {
                    if (!isClickOK) {
                        cancelFunc()
                    }
                }
            }
            return alertDialog.show()
        }
    }
}
