/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.utils

import android.content.Context
import android.content.res.Configuration
import androidx.appcompat.app.AppCompatDelegate
import com.netacom.lite.util.Constants

object ThemeUtils {
    @JvmStatic
    var isDarkModeInSystem: Boolean = false

    fun enableDisplayMode(displayMode: Int) {
        when (displayMode) {
            Constants.DARK_MODE -> {
                // Logger.d("Liem - enable Dark mode")
                AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES)
            }
            Constants.LIGHT_MODE -> {
                // Logger.d("Liem - enable Light mode")
                AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO)
            }
            Constants.SYSTEM_MODE -> {
                // Logger.d("Liem - enable System mode")
                AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_FOLLOW_SYSTEM)
            }
        }
    }

    fun isOsDarkTheme(context: Context): Boolean {
        return when (context.resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK) {
            Configuration.UI_MODE_NIGHT_YES -> true
            Configuration.UI_MODE_NIGHT_NO -> false
            else -> false
        }
    }
}
