package com.netacom.full.widget.chat_footer

import android.view.ViewGroup
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil
import com.netacom.base.chat.adapter.BaseMultiTypeListSimpleAdapter
import com.netacom.base.chat.adapter.BaseViewHolder
import com.netacom.base.chat.imageloader.loadImage
import com.netacom.full.R
import com.netacom.full.databinding.RowImageMessage3picBinding
import com.netacom.full.databinding.RowImageMessage6picBinding
import com.netacom.full.databinding.RowImageMessage9picBinding

class ReplyImageMessageAdapter : BaseMultiTypeListSimpleAdapter<String, ViewDataBinding>(diff = FooterDiff()) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder<ViewDataBinding> {
        return when (viewType) {
            1 -> BaseViewHolder(
                inflateView(parent, R.layout.row_image_message_3pic) as RowImageMessage3picBinding
            )
            2 -> BaseViewHolder(
                inflateView(parent, R.layout.row_image_message_6pic) as RowImageMessage6picBinding
            )
            else -> BaseViewHolder(
                inflateView(parent, R.layout.row_image_message_9pic) as RowImageMessage9picBinding
            )
        }
    }

    override fun onBindViewHolder(holder: BaseViewHolder<ViewDataBinding>, position: Int) {
        getItem(position)?.let { item ->
            with(holder) {
                when (getItemViewType(position)) {
                    1 -> with(binding as RowImageMessage3picBinding) {
                        this.item = item
                        hasDivider = (layoutPosition != itemCount - 1)
                        imgOneImage.loadImage(item)
                    }
                    2 -> with(binding as RowImageMessage6picBinding) {
                        this.item = item
                        hasDivider = (layoutPosition != itemCount - 1)
                        imgTwoImage1.loadImage(item)
                    }
                    else -> with(binding as RowImageMessage9picBinding) {
                        this.item = item
                        hasDivider = (layoutPosition != itemCount - 1)
                        imgTwoImage1.loadImage(item)
                    }
                }
                binding.executePendingBindings()
            }
        }
    }

    override fun bindMultiType(position: Int): Int {
        return if (position <= itemCount) {
            when (itemCount) {
                1 -> 1
                4 -> 2
                else -> 3
            }
        } else -1
    }

    private class FooterDiff : DiffUtil.ItemCallback<String>() {

        override fun areItemsTheSame(oldItem: String, newItem: String): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(oldItem: String, newItem: String): Boolean {
            return oldItem == newItem
        }
    }
}
