/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.widget.chat_header

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import androidx.annotation.AttrRes
import androidx.core.view.isGone
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import com.netacom.base.chat.android_utils.StringUtils
import com.netacom.full.R
import com.netacom.full.databinding.ViewChatHeaderBinding
import com.netacom.full.ui.main.theme.ThemeHelperImpl
import com.netacom.lite.entity.ui.NeChatInfo
import dagger.hilt.android.AndroidEntryPoint
import dagger.hilt.android.WithFragmentBindings
import javax.inject.Inject

@WithFragmentBindings
@AndroidEntryPoint
class ChatHeaderView : FrameLayout {

    private lateinit var mBinding: ViewChatHeaderBinding

    @set:Inject
    internal lateinit var themeHelperImpl: ThemeHelperImpl

    constructor(context: Context) : super(context) {
        init(context)
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init(context)
    }

    constructor(context: Context, attrs: AttributeSet?, @AttrRes defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init(context)
    }

    private fun init(context: Context) {
        val inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        mBinding = DataBindingUtil.inflate(inflater, R.layout.view_chat_header, this, true)

        setupTheme()
    }

    fun setHeader(neChatInfo: NeChatInfo) {
        mBinding.item = neChatInfo
    }

    fun showCallIcon() {
        mBinding.imgVoiceCall.isVisible = true
        mBinding.imgVideoCall.isVisible = true
    }

    fun registerCallBack(callback: ViewChatHeaderCallBack) {
        mBinding.handlers = callback
    }

    fun isGroup(isGroup: Boolean = false) {
        with(mBinding) {
            imgVoiceCall.isGone = isGroup
            imgVideoCall.isGone = isGroup
        }
    }

    fun isNewContact(isNewContact: Boolean = false) {
        with(mBinding) {
            layoutNewContact.isVisible = isNewContact
        }
    }

    fun updateStatus(isOnline: Boolean? = false) {
        with(mBinding) {
            txtTotalMemberOrStatus.text =
                if (isOnline == true) {
                    StringUtils.getString(com.netacom.lite.R.string.str_online_status)
                } else {
                    StringUtils.getString(com.netacom.lite.R.string.str_offline_status)
                }
        }
    }

    fun initForSecret() {
        /*mBinding.imgBack.setImageResource(R.drawable.ic_back_black)
        mBinding.imgVoiceCall.setImageResource(R.drawable.ic_call_black)
        mBinding.imgVideoCall.setImageResource(R.drawable.ic_video_call_black)*/
        mBinding.apply {
            themeHelperImpl.setThemeColorForSecretChat(imgBack, imgVideoCall, imgVoiceCall)
        }
        mBinding.txtTitle.setCompoundDrawablesWithIntrinsicBounds(
            0,
            0,
            R.drawable.ic_secret_title,
            0
        )
    }

    fun setupTheme() {
        mBinding.apply {
            themeHelperImpl.setThemeColorForViews(imgBack, imgVideoCall, imgVoiceCall, btnChangeBg)
        }
    }

    fun hideCallAndVideo() {
        mBinding.imgVoiceCall.visibility = View.GONE
        mBinding.imgVideoCall.visibility = View.GONE
    }

    fun hideActionBlock(isHide: Boolean) {
        mBinding.tvBlock.isVisible = !isHide
    }

    fun hideMemberOrStatus() {
        mBinding.txtTotalMemberOrStatus.isGone = true
    }

    fun setCheckConnection(isConnected: Boolean) {
        mBinding.checkConnection.isGone = isConnected
    }

    fun showChangeBackground() {
        mBinding.txtTitle.text = StringUtils.getString(R.string.background_change)
        hideCallAndVideo()
        hideMemberOrStatus()
        mBinding.imgAvatar.isInvisible = true
        mBinding.btnChangeBg.isVisible = true
    }

    fun hideChangeBackground(isGroup: Boolean = false) {
        if (!isGroup) {
            showCallIcon()
        }
        mBinding.txtTitle.text = mBinding.item?.getDisplayName
        mBinding.imgAvatar.isVisible = true
        mBinding.btnChangeBg.isGone = true
        mBinding.txtTotalMemberOrStatus.isVisible = true
    }

    fun isBackgroundChangeVisible(): Boolean {
        return mBinding.btnChangeBg.isVisible
    }

    fun applyBackground(backgroundUrl: String) {
        mBinding.root.setBackgroundColor(Color.TRANSPARENT)
    }
}
