package com.netacom.full.widget.record

import android.media.MediaRecorder
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.android_utils.TimeUtils
import com.netacom.lite.util.CompressUtil.createAudioFile
import java.io.File
import java.util.concurrent.atomic.AtomicBoolean

/**
Created by vantoan on 26/Aug/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/

class MediaRecordHelper {

    companion object {
        @JvmStatic
        private var mInstance: MediaRecordHelper? = null

        @JvmStatic
        @Synchronized
        fun get(): MediaRecordHelper {
            if (null == mInstance) {
                mInstance = MediaRecordHelper()
            }
            return mInstance!!
        }
    }

    private var mAudioRecord: MediaRecorder? = null
    private val isRecordStarted = AtomicBoolean(false)
    private var recordFileStartTime: Long? = 0L
    private var recordFileDuration: Long? = 0L
    private var audioFile: File? = null

    fun recordDuration() = recordFileDuration ?: 0L

    fun recordFile() = audioFile

    fun startRecord() {
        try {
            if (isRecordStarted.get()) {
                releaseRecorder()
            } else {
                audioFile = createAudioFile()
                if (null == audioFile) {
                    releaseRecorder()
                    return
                }

                mAudioRecord = MediaRecorder().apply {
                    setAudioSource(MediaRecorder.AudioSource.MIC)
                    setOutputFormat(MediaRecorder.OutputFormat.MPEG_4)
                    setAudioEncoder(MediaRecorder.AudioEncoder.HE_AAC)
                    setAudioSamplingRate(16000)
                    setOutputFile(audioFile?.absolutePath)
                    setOnErrorListener { _, _, _ -> }
                }

                mAudioRecord?.prepare()

                mAudioRecord?.start()
                recordFileStartTime = TimeUtils.getNowMills()
                isRecordStarted.set(true)
            }
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            e.printStackTrace()
        }
    }

    fun stopRecord() {
        if (null != mAudioRecord && isRecordStarted.get()) {
            releaseRecorder()
        }
    }

    private fun releaseRecorder() {
        try {
            recordFileDuration = (TimeUtils.getNowMills() - (recordFileStartTime ?: 0)) / 1000
            mAudioRecord?.stop()
            mAudioRecord?.release()
            isRecordStarted.set(false)
            mAudioRecord = null
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            e.printStackTrace()
        }
    }

    fun isRecording(): Boolean {
        return (null != mAudioRecord && isRecordStarted.get())
    }
}
