package com.netacom.full.widget.swipe_layout

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import android.view.View
import android.view.ViewConfiguration
import android.widget.FrameLayout
import androidx.customview.widget.ViewDragHelper

class SwipeLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : FrameLayout(context, attrs, defStyleAttr) {
    private var mViewDragHelper: ViewDragHelper
    private var mContentView: View? = null
    private var mMenuView: View? = null
    private var mMenuWidth: Int = 0
    private var mTouchSlop = 0
    private var menuIsOpen = false
    private var isSwipe = true
    fun setNoSwipe(is_swipe: Boolean) {
        isSwipe = is_swipe
    }

    fun isOpen(): Boolean {
        return menuIsOpen
    }

    private var mScreenWidth: Int

    private var forceClose = false

    private var mGestureDetector: GestureDetector

    init {
        mViewDragHelper = ViewDragHelper.create(this, MyDragHelperCallback())
        mGestureDetector = GestureDetector(context, GestureDetectorCallback())
        mScreenWidth = context.resources.displayMetrics.widthPixels
        mTouchSlop = ViewConfiguration.get(context).scaledTouchSlop
    }

    override fun onFinishInflate() {
        super.onFinishInflate()
        getChildAt(0)?.apply {
            mMenuView = this
        }
        getChildAt(1)?.apply {
            mContentView = this
        }
    }

    override fun onLayout(changed: Boolean, left: Int, top: Int, right: Int, bottom: Int) {
        super.onLayout(changed, left, top, right, bottom)
        mMenuWidth = mMenuView?.measuredWidth ?: 0
    }

    private var leftOffset = 0

    inner class MyDragHelperCallback : ViewDragHelper.Callback() {
        override fun clampViewPositionHorizontal(child: View, left: Int, dx: Int): Int {
            if (!isSwipe) return 0
            leftOffset = left
            if (leftOffset < -mMenuWidth) {
                leftOffset = -mMenuWidth
            } else if (leftOffset >= 0) {
                leftOffset = 0
            }

            return leftOffset
        }

        override fun onViewReleased(releasedChild: View, xvel: Float, yvel: Float) {
            if (!isSwipe) return
            if (forceClose) {
                menuIsOpen = false
                forceClose = false
                leftOffset = 0
                mViewDragHelper.settleCapturedViewAt(0, 0)
                invalidate()
                return
            }

            menuIsOpen = if (leftOffset >= -mMenuWidth / 2) {
                mViewDragHelper.settleCapturedViewAt(0, 0)
                false
            } else {
                mViewDragHelper.settleCapturedViewAt(-mMenuWidth, 0)
                true
            }
            invalidate()
        }

        override fun tryCaptureView(child: View, pointerId: Int): Boolean {
            return child == mContentView
        }
    }

    var downX = 0f
    var downY = 0f
    override fun onInterceptTouchEvent(ev: MotionEvent): Boolean {
        // if (!isSwipe) return true
        when (ev.action) {
            MotionEvent.ACTION_DOWN -> {
                mViewDragHelper.processTouchEvent(ev)
                downX = ev.x
                downY = ev.y
                if (menuIsOpen) {
                    if (downX < mScreenWidth - mMenuWidth) {
                        forceClose = true
//                    if (mViewDragHelper.smoothSlideViewTo(mContentView, 0, 0)) {
//                        invalidate()
//                        menuIsOpen = false
//                    }
                        return true
                    }
                }
            }
            MotionEvent.ACTION_MOVE -> {
                val dy = ev.y - downY
                val dx = ev.x - downX

                if (!menuIsOpen) {
                    return !(Math.abs(dx) < mTouchSlop && Math.abs(dy) < mTouchSlop)
                }
            }
        }

        return super.onInterceptTouchEvent(ev)
    }

    override fun onTouchEvent(event: MotionEvent): Boolean {
        if (mGestureDetector.onTouchEvent(event)) return true
        mViewDragHelper.processTouchEvent(event)
        return true
    }

    override fun computeScroll() {
        if (mViewDragHelper.continueSettling(true)) {
            invalidate()
        }
    }

    fun closeMenu() {
        mContentView?.apply {
            if (mViewDragHelper.smoothSlideViewTo(this, 0, 0)) {
                menuIsOpen = false
                forceClose = false
                leftOffset = 0
            }
        }
        invalidate()
    }

    inner class GestureDetectorCallback : GestureDetector.SimpleOnGestureListener() {
        override fun onFling(e1: MotionEvent?, e2: MotionEvent?, velocityX: Float, velocityY: Float): Boolean {
//            Log.e(TAG, "velocityX -> $velocityX")
//
//            if (!menuIsOpen && velocityX < 0) {//打开menu
//                mContentView.translationX = (-mMenuWidth).toFloat()
//                return true
//            }

            return false
        }
    }
}
