/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */
package com.netacom.full.widget.toolbar

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.annotation.AttrRes
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatToggleButton
import androidx.appcompat.widget.LinearLayoutCompat
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.full.R

class ConversationToolbar : FrameLayout {
    private var mCallBack: DToolbarListener? = null

    constructor(context: Context) : super(context) {
        init(context)
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init(context)
    }

    constructor(context: Context, attrs: AttributeSet?, @AttrRes defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init(context)
    }

    private fun init(context: Context) {
        val view = LayoutInflater.from(context).inflate(R.layout.view_conversation_toolbar, this, true)
        view.findViewById<AppCompatToggleButton>(R.id.toggle_camera)?.apply {
            clickDebounce {
                mCallBack?.onToggleCamera(isChecked)
            }
        }

        view.findViewById<AppCompatToggleButton>(R.id.toggle_mic)?.apply {
            clickDebounce {
                mCallBack?.onToggleMicro(isChecked)
            }
        }

        view.findViewById<AppCompatToggleButton>(R.id.toggle_speaker)?.apply {
            clickDebounce {
                mCallBack?.onToggleSpeaker(isChecked)
            }
        }

        view.findViewById<AppCompatImageView>(R.id.button_end)?.apply {
            clickDebounce {
                mCallBack?.onHangUp()
            }
        }

        view.findViewById<AppCompatImageView>(R.id.btnCallIncomingAccept)?.apply {
            clickDebounce {
                mCallBack?.onAccept()
            }
        }

        view.findViewById<AppCompatImageView>(R.id.btnCallIncomingCancel)?.apply {
            clickDebounce {
                mCallBack?.onHangUp()
            }
        }
    }

    // start call
    fun showAcceptCancel(isShow: Boolean) {
        findViewById<LinearLayoutCompat>(R.id.layoutCalling)?.isVisible = !isShow
        findViewById<ConstraintLayout>(R.id.layoutCallIncoming)?.isVisible = isShow
    }

    fun showEndCall(isShow: Boolean) {
        findViewById<AppCompatImageView>(R.id.button_end)?.isVisible = isShow
    }

    // mic
    fun showMic(isShow: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_mic)?.isVisible = isShow
    }

    fun showMic(isShow: Boolean, isCheck: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_mic)?.apply {
            isVisible = isShow
            isChecked = isCheck
        }
    }

    private fun enableMicro(isChecked: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_mic)?.isChecked = isChecked
    }

    // speaker
    fun showSpeaker(isShow: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_speaker)?.isVisible = isShow
    }

    fun showSpeaker(isShow: Boolean, isCheck: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_speaker)?.apply {
            isVisible = isShow
            isChecked = isCheck
        }
    }

    private fun enableSpeaker(isChecked: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_speaker)?.isChecked = isChecked
    }

    // camera
    private fun showCamera(isShow: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_camera)?.isVisible = isShow
    }

    fun showCamera(isShow: Boolean, isCheck: Boolean) {
        findViewById<AppCompatToggleButton>(R.id.toggle_camera)?.apply {
            isVisible = isShow
            isChecked = isCheck
        }
    }

    fun enableCamera(isChecked: Boolean) {
        mCallBack?.onToggleCamera(isChecked)
        findViewById<AppCompatToggleButton>(R.id.toggle_camera)?.isChecked = isChecked
    }

    fun setAudioInMode() {
        showAcceptCancel(true)
        showMic(false)
        showSpeaker(false)
        showCamera(false)
        showEndCall(false)
        enableMicro(true)
        enableSpeaker(false)
    }

    fun setAudioOutMode() {
        showAcceptCancel(false)
        showMic(true)
        showSpeaker(true)
        showCamera(false)
        showEndCall(true)
        enableMicro(true)
        enableSpeaker(false)
    }

    fun setVideoInMode() {
        showAcceptCancel(true)
        showMic(false)
        showSpeaker(false)
        showCamera(false)
        showEndCall(false)
    }

    fun setVideoOutMode() {
        showAcceptCancel(false)
        showMic(true)
        showSpeaker(true)
        showCamera(false)
        showEndCall(true)
        enableMicro(true)
        enableSpeaker(true)
    }

    fun isCameraOn(): Boolean {
        return findViewById<AppCompatToggleButton>(R.id.toggle_camera)?.isChecked ?: false
    }

    fun isSpeakerOn(): Boolean {
        return findViewById<AppCompatToggleButton>(R.id.toggle_speaker)?.isChecked ?: false
    }

    fun isAudioOn(): Boolean {
        return findViewById<AppCompatToggleButton>(R.id.toggle_mic)?.isChecked ?: false
    }

    fun setDToolbarClickListener(listener: DToolbarListener?) {
        mCallBack = listener
    }
}
