/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.widget.toolbar

import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.util.TypedValue
import android.view.View
import android.widget.FrameLayout
import android.widget.TextView
import androidx.appcompat.widget.AppCompatImageView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.view.isGone
import androidx.core.view.isInvisible
import androidx.core.view.isVisible
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.binding.clickDebounce
import com.netacom.base.chat.util.isResource
import com.netacom.full.R
import com.netacom.lite.sdk.AppID

class CoreToolBar : FrameLayout {

    private var textTitle: TextView? = null
    private var textActionRight: TextView? = null
    private var buttonLeft: AppCompatImageView? = null
    private var buttonRight: AppCompatImageView? = null
    private var rlActionRight: FrameLayout? = null
    private var rlToolBar: ConstraintLayout? = null
    private var textActionLeft: TextView? = null
    private var checkConnection: TextView? = null
    private var rlActionLeft: FrameLayout? = null
    private var vExpand: View? = null

    constructor(context: Context) : super(context) {
        init(context, null)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init(context, attrs)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init(context, attrs)
    }

    private fun init(context: Context, attrs: AttributeSet?) {
        if (attrs == null) {
            return
        }
        val array = context.obtainStyledAttributes(attrs, R.styleable.CoreToolBar)
        try {
            val view = inflate(context, R.layout.layout_tool_bar, this)
            // region FindViewById
            textTitle = view.findViewById(R.id.tvCenter)
            textActionRight = view.findViewById(R.id.tvRight)
            buttonLeft = view.findViewById(R.id.btnLeft)
            buttonRight = view.findViewById(R.id.btnRight)
            rlActionRight = view.findViewById(R.id.layoutRight)
            rlToolBar = view.findViewById(R.id.layoutToolbar)
            textActionLeft = view.findViewById(R.id.tvLeft)
            rlActionLeft = view.findViewById(R.id.layoutLeft)
            vExpand = view.findViewById(R.id.v_expand)
            checkConnection = view.findViewById(R.id.checkConnection)
            // endregion
            // region Title
            textTitle?.setTextColor(
                array.getColor(
                    R.styleable.CoreToolBar_core_titleColor,
                    ActivityCompat.getColor(context, android.R.color.white)
                )
            )
            val title = array.getString(R.styleable.CoreToolBar_core_title)
            if (!TextUtils.isEmpty(title)) setTitle(title)
            val textSize = array.getDimension(R.styleable.CoreToolBar_core_titleSize, -1f)
            if (textSize != -1f) {
                textTitle?.apply {
                    setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize)
                }
            }
            val isExpand = array.getBoolean(R.styleable.CoreToolBar_core_is_expand, true)
            if (isExpand) {
                vExpand?.isVisible = true
                rlToolBar?.layoutParams?.height = context.resources.getDimension(R.dimen.dp_96).toInt()
            }
            val isTextActionRight = array.getBoolean(
                R.styleable.CoreToolBar_core_is_text_right,
                false
            )
            if (isTextActionRight) {
                buttonRight?.isGone = true
                textActionRight?.isVisible = true
                val textAction = array.getText(R.styleable.CoreToolBar_core_right_action_text)
                textActionRight?.text = textAction
            } else {
                buttonRight?.isVisible = true
                textActionRight?.isGone = true
            }
            val isTextActionLeft =
                array.getBoolean(R.styleable.CoreToolBar_core_is_text_left, false)
            if (isTextActionLeft) {
                buttonLeft?.isGone = true
                textActionLeft?.isVisible = true

                val textAction = array.getText(R.styleable.CoreToolBar_core_left_action_text)
                textActionLeft?.text = textAction
            } else {
                buttonLeft?.isVisible = true
                textActionLeft?.isGone = true
            }
            if (array.hasValue(R.styleable.CoreToolBar_core_background)) {
                rlToolBar?.setBackgroundResource(
                    array.getResourceId(
                        R.styleable.CoreToolBar_core_background,
                        ActivityCompat.getColor(context, android.R.color.transparent)
                    )
                )
            }
            // region Button
            val l = array.getResourceId(R.styleable.CoreToolBar_core_drawableLeft, -1)
            val r = array.getResourceId(R.styleable.CoreToolBar_core_drawableRight, -1)
            if (l != -1) setDrawableLeft(l)
            if (r != -1) setDrawableRight(r)
            // endregion
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            e.printStackTrace()
        } finally {
            array.recycle()
        }
    }

    fun setTitle(title: String?) {
        textTitle?.text = title
    }

    fun setOnLeftClickListener(listener: OnClickListener) {
        if (buttonLeft?.isVisible == true) {
            buttonLeft?.clickDebounce(listener)
        } else if (textActionLeft?.isVisible == true) {
            textActionLeft?.clickDebounce(listener)
        }
    }

    fun setOnRightClickListener(listener: OnClickListener) {
        if (buttonRight?.isVisible == true) {
            buttonRight?.clickDebounce(listener)
        } else if (textActionRight?.isVisible == true) {
            textActionRight?.clickDebounce(listener)
        }
    }

    private fun setDrawableLeft(icon: Int) {
        buttonLeft?.apply {
            if (icon == Integer.MIN_VALUE) {
                isInvisible = true
            } else {
                isVisible = true
                setImageResource(icon)
            }
        }
    }

    private fun setDrawableRight(icon: Int) {
        buttonRight?.apply {
            if (icon == Integer.MIN_VALUE) {
                isInvisible = true
            } else {
                isVisible = true
                setImageResource(icon)
            }
        }
    }

    fun setTextLeft(text: String) {
        rlActionLeft?.isVisible = true
        buttonLeft?.isGone = true
        textActionLeft?.isVisible = true
        textActionLeft?.text = text
    }

    fun setCheckConnection(isConnected: Boolean) {
        checkConnection?.isGone = isConnected
    }

    fun setTextRight(text: String) {
        rlActionRight?.isVisible = true
        buttonRight?.isGone = true
        textActionRight?.isVisible = true
        textActionRight?.text = text
    }

    fun setIconRight(icon: Int) {
        rlActionRight?.isVisible = true
        buttonRight?.isVisible = true
        textActionRight?.isGone = true
        setDrawableRight(icon)
    }

    fun hideActionRight() {
        rlActionRight?.isInvisible = true
    }

    fun showActionRight() {
        rlActionRight?.isVisible = true
    }

    fun initForSecret(resId: Int) {
        if (resId > 0) rlToolBar?.setBackgroundResource(resId)
    }

    fun setColorTextLeft(resource: Int) {
        textActionLeft?.setTextColor(resource)
    }

    fun setColorTextRight(resource: Int) {
        textActionRight?.setTextColor(resource)
    }

    fun getTextRight(): View? {
        return textActionRight
    }

    fun getTextLeft(): View? {
        return textActionRight
    }

    fun setColorTextTitle(resource: Int) {
        textTitle?.setTextColor(resource)
    }

    fun getButtonLeft(): AppCompatImageView? {
        return buttonLeft
    }

    fun getButtonRight(): AppCompatImageView? {
        return buttonRight
    }

    fun setBackgroundTheme(appId: Int, isDarkMode: Boolean, resourceId: Int) {
        if (isDarkMode) {
            rlToolBar?.setBackgroundColor(
                ContextCompat.getColor(
                    context,
                    R.color.color_black_25272a
                )
            )
        } else {
            when {
                appId == AppID.GALO -> {
                    rlToolBar?.setBackgroundColor(ContextCompat.getColor(context, R.color.color_green_gchat))
                }
                isResource(context, resourceId) -> {
                    rlToolBar?.setBackgroundResource(resourceId)
                }
                else -> {
                    rlToolBar?.setBackgroundColor(resourceId)
                }
            }
        }
    }

    fun setEnableActionRight(isEnable: Boolean) {
        rlActionRight?.isEnabled = isEnable
        textActionRight?.isEnabled = isEnable
    }
}
