package com.netacom.full.widget.video

import com.google.android.exoplayer2.ExoPlaybackException
import com.google.android.exoplayer2.PlaybackPreparer
import com.google.android.exoplayer2.Player
import com.google.android.exoplayer2.video.VideoListener
import com.netacom.base.chat.logger.Logger
import javax.inject.Inject

class PlayerExoHelper @Inject constructor() : Player.EventListener, VideoListener, PlaybackPreparer {
    private var mCustomExoPlayerView: ExoPlayerView? = null
    var linkUrl = ""
    private var subtitle: String? = ""
    private var mPlayerStateListener: IPlayerStateListener? = null
    private var mPlayerClickListener: IPlayerClickListener? = null

    fun setupExoplayer(playerView: ExoPlayerView) {
        if (mCustomExoPlayerView?.isPlaying() == true || mCustomExoPlayerView?.isBuffering() == true) {
            mCustomExoPlayerView?.stopExoPlayer()
            mCustomExoPlayerView?.releasePlayer()
            mPlayerStateListener?.onVideoEnd()
        }
        mCustomExoPlayerView = playerView
        mCustomExoPlayerView?.initializePlayer()
        mCustomExoPlayerView?.createExoPlayer(this)
    }

    fun updateLink(linkUrl: String) {
        this.linkUrl = linkUrl
    }

    fun runExoPlayer(
        linkUrl: String? = "",
        subtitle: String? = null,
        position: Long = 0L,
        apphash: String? = "",
        token: String
    ) {
        // Logger.e("runExoPlayer=$linkUrl subtitle=$subtitle position=$position")
        if (linkUrl.isNullOrEmpty()) {
            mCustomExoPlayerView?.runExoPlayer(this.linkUrl, this.subtitle, position, apphash.toString(), token)
        } else {
            this.linkUrl = linkUrl
            this.subtitle = subtitle
            mCustomExoPlayerView?.runExoPlayer(linkUrl, subtitle, position, apphash.toString(), token)
        }
    }

    fun checkPlayer(): Boolean = mCustomExoPlayerView?.checkPlayer() ?: false

    fun setMutePlayer() = mCustomExoPlayerView?.setMutePlayer()

    fun setUnMutePlayer() = mCustomExoPlayerView?.setUnMutePlayer()

    fun releaseExoPlayer() = mCustomExoPlayerView?.releasePlayer()

    fun isShowController() = mCustomExoPlayerView?.isShowController()

    fun replay() = mCustomExoPlayerView?.replay()

    fun playExoPlayer() {
        mPlayerStateListener?.onVideoResume()
        mCustomExoPlayerView?.setPlayWhenReady(true)
    }

    fun pauseExoPlayer() {
        mPlayerStateListener?.onVideoPause()
        mCustomExoPlayerView?.setPlayWhenReady(false)
        mCustomExoPlayerView?.pauseExoPlayer()
    }

    fun currentPosition() = mCustomExoPlayerView?.getPlayer()?.currentPosition ?: 0L

    fun stopExoPlayer() = mCustomExoPlayerView?.stopExoPlayer()

    fun seekTo(position: Long) = mCustomExoPlayerView?.seekTo(position)

    fun isPlaying(): Boolean = mCustomExoPlayerView?.isPlaying() ?: false

    fun setPlayerStateListener(mPlayerStateListener: IPlayerStateListener) {
        this.mPlayerStateListener = mPlayerStateListener
    }

    fun setPlayerClickListener(mPlayerClickListener: IPlayerClickListener) {
        this.mPlayerClickListener = mPlayerClickListener
    }

    fun getPlayerClickListener() = this.mPlayerClickListener

    fun trackingTime() {
        getExoPlayer()?.apply {
            mPlayerStateListener?.onVideoTracking(progress = currentPosition, duration = duration)
        }
    }

    fun getTrackSelector() = mCustomExoPlayerView?.getTrackSelector()

    fun setResizeMode(resizeMode: Int) = mCustomExoPlayerView?.setResizeModeRaw(resizeMode)

    fun switchTargetView(oldPlayerView: ExoPlayerView?, newPlayerView: ExoPlayerView?) {
        mCustomExoPlayerView?.switchTargetView(oldPlayerView, newPlayerView)
    }

    fun hideController() {
        mCustomExoPlayerView?.hideController()
    }

    fun getExoPlayer(): Player? = mCustomExoPlayerView?.getPlayer()

    /*fun setView(view: CustomExoPlayerView?) {
        view?.apply {
            // mCustomExoPlayerView.setSizeTextView(width, height)
        }
    }*/

    fun release() {
        mPlayerStateListener = null
    }

    override fun preparePlayback() {
        mCustomExoPlayerView?.retry()
    }

    override fun onPlayerStateChanged(playWhenReady: Boolean, playbackState: Int) {
        Logger.d("onPlayerStateChanged=$playbackState")
        mPlayerStateListener?.apply {
            when (playbackState) {
                Player.STATE_BUFFERING -> onVideoLoading()
                Player.STATE_READY -> onVideoStarted()
                Player.STATE_ENDED -> onVideoEnd()
                Player.STATE_IDLE -> {
                }
            }
        }
    }

    override fun onPlayerError(error: ExoPlaybackException) {
        Logger.e(error.message)
        super.onPlayerError(error)
        mPlayerStateListener?.onVideoError(error)
        error.printStackTrace()
    }

    override fun onVideoSizeChanged(
        width: Int,
        height: Int,
        unappliedRotationDegrees: Int,
        pixelWidthHeightRatio: Float
    ) {
        // Logger.e("onVideoSizeChanged=width:${width}_height${height}_pixelWidthHeightRatio$pixelWidthHeightRatio")
        mPlayerStateListener?.onVideoSizeChanged(width)
    }
}
