/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.worker.call

import android.content.Context
import android.util.Log
import androidx.hilt.work.HiltWorker
import androidx.work.CoroutineWorker
import androidx.work.WorkerParameters
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.netacom.base.chat.json.JsonSerializer
import com.netacom.base.chat.logger.Logger
import com.netacom.full.ui.sdk.NetAloSDK
import com.netacom.lite.define.FirebaseDefine
import com.netacom.lite.entity.socket.Call
import com.netacom.lite.repository.SocketRepository
import dagger.assisted.Assisted
import dagger.assisted.AssistedInject
import java.util.Calendar

/**
Created by vantoan on 28/Sep/2020
Company: Netacom.
Email: huynhvantoan.itc@gmail.com
 **/
@HiltWorker
class CallWorker @AssistedInject constructor(
    @Assisted context: Context,
    @Assisted workerParameters: WorkerParameters,
    val socketRepository: SocketRepository,
    private val jsonSerializer: JsonSerializer
) : CoroutineWorker(context, workerParameters) {

    override suspend fun doWork(): Result {
        return try {
            jsonSerializer.asObject(inputData.getString(FirebaseDefine.KEY_DATA), Call::class.java)?.apply {
                Logger.e("CallWorker=$this")
                Logger.e("CallWorker=${socketRepository.isConnect()}")
                if (Calendar.getInstance().timeInMillis / 1000 - (this.mStartedAt?.toLongOrNull() ?: 0L) > 30) {
                    return@apply
                }
                if (!socketRepository.isConnect()) {
                    socketRepository.connectSocket { isConnected ->
                        if (isConnected) {
                            Logger.e("CallWorker=$isConnected")
                            NetAloSDK.openNetAlo(applicationContext, call = this, isNotification = true)
                            /**
                             * Keep this line for back-up plan, will remote it later
                             */
                            // IncomeActivity.start(applicationContext, this)
                        }
                    }
                } else {
                    Logger.e("CallWorker=isConnect==false")
                    NetAloSDK.openNetAlo(applicationContext, call = this, isNotification = true)
                    /**
                     * Keep this line for back-up plan, will remote it later
                     */
                    // IncomeActivity.start(applicationContext, this)
                }
            }
            Result.success()
        } catch (e: Exception) {
            FirebaseCrashlytics.getInstance().recordException(e)
            Log.d("qqq", "!! exception.message:${e.message}")
            Result.failure()
        }
    }
}
