/*
 * *Created by NetaloTeamAndroid on 2020
 * Company: Netacom.
 *  *
 */

package com.netacom.full.worker.upload

import android.content.Context
import androidx.hilt.work.HiltWorker
import androidx.work.CoroutineWorker
import androidx.work.WorkerParameters
import androidx.work.workDataOf
import com.netacom.lite.util.Constants
import dagger.assisted.Assisted
import dagger.assisted.AssistedInject
import kotlinx.coroutines.asCoroutineDispatcher
import kotlinx.coroutines.withContext
import java.util.concurrent.Executors

@HiltWorker
class MergeWorker @AssistedInject constructor(
    @Assisted context: Context,
    @Assisted workerParameters: WorkerParameters
) : CoroutineWorker(context, workerParameters) {

    companion object {
        const val KEY_MERGE_RESULT = "KEY_MERGE_RESULT"
        const val KEY_UPLOAD_RESULT = "KEY_UPLOAD_RESULT"
    }

    override suspend fun doWork(): Result {
        return withContext(Executors.newFixedThreadPool(Constants.THREAD_UPLOAD_LIMIT).asCoroutineDispatcher()) {
            Result.success(workDataOf(Pair(KEY_MERGE_RESULT, inputData.getStringArray(KEY_UPLOAD_RESULT))))
        }
    }
}
