/*
 * Decompiled with CFR 0.152.
 */
package wang.ramboll.extend.basic.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanUtils {
    public static List<Class<?>> getAllClassByPackageName(Package pkg) throws IOException, ClassNotFoundException {
        String packageName = pkg.getName();
        List<Class<?>> returnClassList = ClassScanUtils.getClassesWithAnnotation(packageName, null);
        return returnClassList;
    }

    public static <A extends Annotation> List<Class<?>> getAllClassWithAnnotationByPackageName(String packageName, Class<A> annotationClass) throws IOException, ClassNotFoundException {
        List<Class<?>> returnClassList = ClassScanUtils.getClassesWithAnnotation(packageName, annotationClass);
        return returnClassList;
    }

    public static List<Class<?>> getAllClassByInterface(Class<?> c) throws IOException, ClassNotFoundException {
        String packageName;
        List<Class<?>> allClass;
        ArrayList returnClassList = null;
        if (c.isInterface() && (allClass = ClassScanUtils.getClassesWithAnnotation(packageName = c.getPackage().getName(), null)) != null) {
            returnClassList = new ArrayList();
            for (Class<?> cls : allClass) {
                if (!c.isAssignableFrom(cls) || c.equals(cls)) continue;
                returnClassList.add(cls);
            }
        }
        return returnClassList;
    }

    public static String[] getPackageAllClassName(String classLocation, String packageName) {
        String[] packagePathSplit = packageName.split("[.]");
        String realClassLocation = classLocation;
        int packageLength = packagePathSplit.length;
        for (int i = 0; i < packageLength; ++i) {
            realClassLocation = realClassLocation + File.separator + packagePathSplit[i];
        }
        File packageDir = new File(realClassLocation);
        if (packageDir.isDirectory()) {
            String[] allClassName = packageDir.list();
            return allClassName;
        }
        return null;
    }

    private static boolean containsAnnotation(Class cls, Class<? extends Annotation> annotation) {
        HashSet s = new HashSet();
        if (cls.isAnnotationPresent(annotation)) {
            return true;
        }
        for (Annotation a : Arrays.asList(cls.getAnnotations())) {
            if (Proxy.isProxyClass(a.getClass())) {
                Class<?>[] interfaces = a.getClass().getInterfaces();
                for (Class<?> b : Arrays.asList(interfaces)) {
                    if (!ClassScanUtils.containsAnnotation(b, annotation)) continue;
                    return true;
                }
                continue;
            }
            if (!ClassScanUtils.containsAnnotation(a.getClass(), annotation)) continue;
            return true;
        }
        return false;
    }

    private static List<Class<?>> getClassesWithAnnotation(String packageName, Class annotation) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            JarFile jarFile;
            JarURLConnection connection;
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                ClassScanUtils.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                continue;
            }
            if (!"jar".equalsIgnoreCase(protocol) || (connection = (JarURLConnection)url.openConnection()) == null || (jarFile = connection.getJarFile()) == null) continue;
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            while (jarEntryEnumeration.hasMoreElements()) {
                String className;
                Class<?> cls;
                JarEntry entry = jarEntryEnumeration.nextElement();
                String jarEntryName = entry.getName();
                if (!jarEntryName.contains(".class") || !jarEntryName.replaceAll("/", ".").startsWith(packageName) || !ClassScanUtils.containsAnnotation(cls = Class.forName(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replace("/", ".")), annotation)) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, List<Class<?>> classes) throws ClassNotFoundException {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirFiles = dir.listFiles(f -> recursive && f.isDirectory() || f.getName().endsWith(".class"))) {
            if (file.isDirectory()) {
                ClassScanUtils.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            classes.add(Class.forName(packageName + '.' + className));
        }
    }
}

