/*
 * Decompiled with CFR 0.152.
 */
package wang.ramboll.extend.basic.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;

public class JsonUtils {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static final Gson dateFormatGson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();
    private static final JsonDeserializer<Date> dateJsonDeserializer = (json, typOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong());
    private static final JsonSerializer<Date> dateJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive((Number)src.getTime());
    private static final Gson dateToMillisecondsGson = new GsonBuilder().registerTypeAdapter(Date.class, dateJsonDeserializer).registerTypeAdapter(Date.class, dateJsonSerializer).disableHtmlEscaping().create();

    public static Gson GSON() {
        return gson;
    }

    public static Gson GSON_DATEFORMATE() {
        return dateFormatGson;
    }

    public static <T> T parseJsonToObject(String json, Class<T> objectClass, boolean formatDate) {
        return (T)(formatDate ? dateFormatGson.fromJson(json, objectClass) : gson.fromJson(json, objectClass));
    }

    public static <T> T parseJsonToObject(String json, TypeToken<T> typeToken, boolean formatDate) {
        return JsonUtils.parseJsonToObject(json, typeToken.getType(), formatDate);
    }

    public static <T> T parseJsonToObject(String json, Type t, boolean formatDate) {
        return (T)(formatDate ? dateFormatGson.fromJson(json, t) : gson.fromJson(json, t));
    }

    public static String parseObjectToJson(Object obj, boolean formatDate) {
        if (obj instanceof String) {
            return obj.toString();
        }
        return formatDate ? dateFormatGson.toJson(obj) : gson.toJson(obj);
    }

    public static String parseObjectToJsonDateToMilliseconds(Object obj) {
        return dateToMillisecondsGson.toJson(obj);
    }
}

