package work.eddiejamsession.exception.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

import static java.lang.Thread.sleep;
import static java.time.temporal.ChronoUnit.MINUTES;
import static java.time.temporal.ChronoUnit.SECONDS;
import static java.util.Optional.empty;
import static java.util.Optional.ofNullable;
import static java.util.logging.Logger.getGlobal;

public class ExceptionUtils {

    private static void log(Throwable toWrap) {
        getGlobal().log(Level.SEVERE, toWrap, () -> "");
    }

    public interface VoidExceptionThrower {
        void doSomethingUnsafe() throws Exception;
    }

    public static <T> Optional<T> tryOnce(ExceptionThrower<T> thrower) {
        try {
            return ofNullable(thrower.doSomethingUnsafe());
        } catch (Throwable th) {
            log(th);
            return empty();
        }
    }

    public static <T> void toss(VoidExceptionThrower thrower) {
        try {
            thrower.doSomethingUnsafe();
        } catch (Throwable th) {
            log(th);
            throw new RuntimeException(th);
        }
    }

    public static <T> T toss(ExceptionThrower<T> thrower) {
        try {
            return thrower.doSomethingUnsafe();
        } catch (Throwable th) {
            log(th);
            throw new RuntimeException(th);
        }
    }

    public static <T> void gag(VoidExceptionThrower thrower) {
        try {
            thrower.doSomethingUnsafe();
        } catch (Throwable th) {
            log(th);
        }
    }

    public static <T> T whilst(ExceptionThrower<T> thrower) {
        Duration oneTryTimeout = Duration.of(1, MINUTES);
        Duration backOff = Duration.of(1, SECONDS);
        return whilst(thrower, oneTryTimeout, backOff);
    }

    public static <T> T whilst(ExceptionThrower<T> thrower, Duration oneTryTimeout, Duration backOff) {
        while (true) {
            try {
                return ForkJoinPool.commonPool()
                        .submit(() -> toss(thrower))
                        .get(oneTryTimeout.toMillis(), TimeUnit.MILLISECONDS);
            } catch (Throwable th) {
                log(new RuntimeException("Trying to recover and waiting back off time..", th));
                nap(backOff);
            }
        }
    }

    public static void nap(Duration backOff) {
        gag(() -> sleep(backOff.toMillis()));
    }

    public static void nap(Integer amount, TemporalUnit unit) {
        gag(() -> sleep(Duration.of(amount, unit).toMillis()));
    }

    public interface ExceptionThrower<T> {
        T doSomethingUnsafe() throws Exception;
    }
}
