/*
 * Decompiled with CFR 0.152.
 */
package work.gaigeshen.tripartite.ding.openapi.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import work.gaigeshen.tripartite.core.client.AbstractWebExecutorClient;
import work.gaigeshen.tripartite.core.client.ClientException;
import work.gaigeshen.tripartite.core.client.ServerHost;
import work.gaigeshen.tripartite.core.client.ServerHostException;
import work.gaigeshen.tripartite.core.client.ServerHosts;
import work.gaigeshen.tripartite.core.client.accesstoken.AccessToken;
import work.gaigeshen.tripartite.core.client.accesstoken.AccessTokenHelper;
import work.gaigeshen.tripartite.core.client.accesstoken.AccessTokenManager;
import work.gaigeshen.tripartite.core.client.accesstoken.AccessTokenManagerException;
import work.gaigeshen.tripartite.core.client.config.Config;
import work.gaigeshen.tripartite.core.client.config.ConfigException;
import work.gaigeshen.tripartite.core.client.parameters.ClientParameters;
import work.gaigeshen.tripartite.core.client.response.ClientResponse;
import work.gaigeshen.tripartite.core.header.Headers;
import work.gaigeshen.tripartite.core.interceptor.AbstractInterceptor;
import work.gaigeshen.tripartite.core.interceptor.InterceptingException;
import work.gaigeshen.tripartite.core.interceptor.Interceptor;
import work.gaigeshen.tripartite.core.ratelimiter.RateLimiterService;
import work.gaigeshen.tripartite.core.util.ArgumentValidate;
import work.gaigeshen.tripartite.ding.openapi.client.DingClient;
import work.gaigeshen.tripartite.ding.openapi.config.DingConfig;
import work.gaigeshen.tripartite.ding.openapi.parameters.DingApiParameters;
import work.gaigeshen.tripartite.ding.openapi.parameters.DingOapiParameters;
import work.gaigeshen.tripartite.ding.openapi.parameters.api.DingAccessTokenParameters;
import work.gaigeshen.tripartite.ding.openapi.parameters.api.DingAuthCorpAccessTokenParameters;
import work.gaigeshen.tripartite.ding.openapi.response.DingApiResponse;
import work.gaigeshen.tripartite.ding.openapi.response.DingOapiResponse;
import work.gaigeshen.tripartite.ding.openapi.response.api.DingAccessTokenResponse;
import work.gaigeshen.tripartite.ding.openapi.response.api.DingAuthCorpAccessTokenResponse;

public class DefaultDingClient
extends AbstractWebExecutorClient<DingConfig>
implements DingClient {
    private final DingConfig config;
    private final AccessTokenManager<DingConfig> accessTokenManager;
    private final RateLimiterService rateLimiterService;

    protected DefaultDingClient(DingConfig config, AccessTokenManager<DingConfig> accessTokenManager) {
        ArgumentValidate.notNull((Object)config, (String)"config cannot be null");
        ArgumentValidate.notNull(accessTokenManager, (String)"accessTokenManager cannot be null");
        this.config = config;
        this.accessTokenManager = accessTokenManager;
        this.rateLimiterService = RateLimiterService.create((double)16.0);
    }

    static DefaultDingClient create(DingConfig config, AccessTokenManager<DingConfig> accessTokenManager) {
        return new DefaultDingClient(config, accessTokenManager);
    }

    public AccessToken getNewAccessToken() throws ClientException {
        String path;
        boolean hasAuthCorpId = Objects.nonNull(this.config.getAuthCorpId());
        String string = path = hasAuthCorpId ? "/v1.0/oauth2/corpAccessToken" : "/v1.0/oauth2/accessToken";
        if (hasAuthCorpId) {
            DingAuthCorpAccessTokenParameters parameters = new DingAuthCorpAccessTokenParameters();
            parameters.suiteKey = this.config.getAppKey();
            parameters.suiteSecret = this.config.getAppSecret();
            parameters.authCorpId = this.config.getAuthCorpId();
            parameters.suiteTicket = "none";
            DingAuthCorpAccessTokenResponse response = (DingAuthCorpAccessTokenResponse)this.execute(parameters, DingAuthCorpAccessTokenResponse.class, path, new Object[0]);
            String accessToken = response.accessToken;
            Long expireIn = response.expireIn;
            if (Objects.isNull(accessToken) || Objects.isNull(expireIn)) {
                throw new ClientException("acquired access token is invalid: " + this.config);
            }
            return AccessTokenHelper.createAccessToken((Config)this.config, (String)accessToken, (long)expireIn);
        }
        DingAccessTokenParameters parameters = new DingAccessTokenParameters();
        parameters.appKey = this.config.getAppKey();
        parameters.appSecret = this.config.getAppSecret();
        DingAccessTokenResponse response = (DingAccessTokenResponse)this.execute(parameters, DingAccessTokenResponse.class, path, new Object[0]);
        String accessToken = response.accessToken;
        Long expireIn = response.expireIn;
        if (Objects.isNull(accessToken) || Objects.isNull(expireIn)) {
            throw new ClientException("acquired access token is invalid: " + this.config);
        }
        return AccessTokenHelper.createAccessToken((Config)this.config, (String)accessToken, (long)expireIn);
    }

    protected void initInternal() throws ClientException {
        try {
            this.accessTokenManager.addNewAccessToken((Config)this.config, this.getNewAccessToken());
        }
        catch (AccessTokenManagerException e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
    }

    protected List<AbstractInterceptor> createInterceptors() {
        return Collections.singletonList(new AbstractInterceptor(){

            protected void updateRequest(Interceptor.Request request) throws InterceptingException {
                String accessTokenValue = DefaultDingClient.this.getAccessTokenValue();
                if (Objects.isNull(accessTokenValue)) {
                    return;
                }
                Headers headers = request.headers();
                headers.putValue("x-acs-dingtalk-access-token", accessTokenValue);
            }

            protected void validateResponse(Interceptor.Request request, Interceptor.Response response) throws InterceptingException {
            }
        });
    }

    public DingConfig getConfig() throws ConfigException {
        return this.config;
    }

    public AccessTokenManager<DingConfig> getAccessTokenManager() {
        return this.accessTokenManager;
    }

    public RateLimiterService getRateLimiterService() {
        return this.rateLimiterService;
    }

    protected <R extends ClientResponse> R validateResponse(R response) throws ClientException {
        ClientResponse preValidated = super.validateResponse(response);
        if (preValidated instanceof DingOapiResponse) {
            DingOapiResponse dingOapiResponse = (DingOapiResponse)preValidated;
            if (!Objects.equals(0, dingOapiResponse.errcode)) {
                throw new ClientException("[ " + dingOapiResponse.errcode + " ] - [ " + dingOapiResponse.errmsg + " ]");
            }
        }
        return (R)preValidated;
    }

    public ServerHost getServerHost(ClientParameters parameters, Class<? extends ClientResponse> responseClass) throws ServerHostException {
        if (parameters instanceof DingApiParameters || DingApiResponse.class.isAssignableFrom(responseClass)) {
            return ServerHost.create((String)this.config.getApiServerHost());
        }
        if (parameters instanceof DingOapiParameters || DingOapiResponse.class.isAssignableFrom(responseClass)) {
            return ServerHost.create((String)this.config.getOapiServerHost());
        }
        throw new ServerHostException("could not determine server host: " + parameters + ", " + responseClass);
    }

    public Collection<ServerHost> getServerHosts() throws ServerHostException {
        return ServerHosts.create((String[])new String[]{this.config.getApiServerHost(), this.config.getOapiServerHost()});
    }
}

