/*
 * Decompiled with CFR 0.152.
 */
package work.gaigeshen.tripartite.ding.openapi.config;

import java.util.Objects;
import work.gaigeshen.tripartite.core.client.config.Config;

public class DingConfig
implements Config {
    private final String apiServerHost;
    private final String oapiServerHost;
    private final String authCorpId;
    private final String agentId;
    private final String appKey;
    private final String appSecret;
    private final String secretKey;
    private final String token;

    private DingConfig(Builder builder) {
        this.apiServerHost = builder.apiServerHost;
        this.oapiServerHost = builder.oapiServerHost;
        this.authCorpId = builder.authCorpId;
        this.agentId = builder.agentId;
        this.appKey = builder.appKey;
        this.appSecret = builder.appSecret;
        this.secretKey = builder.secretKey;
        this.token = builder.token;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DingConfig that = (DingConfig)o;
        return Objects.equals(this.appKey, that.appKey);
    }

    public int hashCode() {
        return Objects.hash(this.appKey);
    }

    public String toString() {
        return "DingConfig: " + this.appKey;
    }

    public String getApiServerHost() {
        return this.apiServerHost;
    }

    public String getOapiServerHost() {
        return this.oapiServerHost;
    }

    public String getAuthCorpId() {
        return this.authCorpId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getToken() {
        return this.token;
    }

    public static class Builder {
        private String apiServerHost;
        private String oapiServerHost;
        private String authCorpId;
        private String agentId;
        private String appKey;
        private String appSecret;
        private String secretKey;
        private String token;

        public Builder setApiServerHost(String apiServerHost) {
            this.apiServerHost = apiServerHost;
            return this;
        }

        public Builder setOapiServerHost(String oapiServerHost) {
            this.oapiServerHost = oapiServerHost;
            return this;
        }

        public Builder setAuthCorpId(String authCorpId) {
            this.authCorpId = authCorpId;
            return this;
        }

        public Builder setAgentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setAppSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public DingConfig build() {
            return new DingConfig(this);
        }
    }
}

