/*
 * Decompiled with CFR 0.152.
 */
package work.gaigeshen.tripartite.ding.openapi.notify;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import work.gaigeshen.tripartite.core.notify.DefaultNotifyContent;
import work.gaigeshen.tripartite.core.notify.NotifyContentReceiver;
import work.gaigeshen.tripartite.core.notify.filter.AbstractDefaultNotifyContentFilter;
import work.gaigeshen.tripartite.core.util.TimestampUtils;
import work.gaigeshen.tripartite.ding.openapi.config.DingConfig;
import work.gaigeshen.tripartite.ding.openapi.notify.DingNotifyContentReceiver;

public class DingNotifyContentFilter
extends AbstractDefaultNotifyContentFilter {
    public static final String REPLY_TEXT_TEMPLATE = "{\"msg_signature\":\"%s\",\"timeStamp\":\"%s\",\"nonce\":\"%s\",\"encrypt\":\"%s\"}";

    public DingNotifyContentFilter(DingNotifyContentReceiver receiver) {
        super((NotifyContentReceiver)receiver);
    }

    protected void renderOnSuccess(DefaultNotifyContent notifyContent, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.renderInternal("success", notifyContent, response);
    }

    protected void renderOnFail(DefaultNotifyContent notifyContent, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.renderInternal("fail", notifyContent, response);
    }

    private void renderInternal(String replyPlainText, DefaultNotifyContent notifyContent, HttpServletResponse response) throws ServletException, IOException {
        String encrypted;
        DingConfig dingConfig = (DingConfig)notifyContent.getValue("ding_config");
        String timestamp = TimestampUtils.unixTimestamp();
        String nonce = RandomStringUtils.randomAlphanumeric((int)16);
        try {
            encrypted = DingNotifyContentReceiver.encrypt(dingConfig, replyPlainText);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        String signature = DingNotifyContentReceiver.genSignature(dingConfig, timestamp, nonce, encrypted);
        String replyText = String.format(REPLY_TEXT_TEMPLATE, signature, timestamp, nonce, encrypted);
        response.setContentType("application/json;charset=UTF-8");
        response.getOutputStream().write(replyText.getBytes(StandardCharsets.UTF_8));
    }
}

