/*
 * Decompiled with CFR 0.152.
 */
package work.gaigeshen.tripartite.ding.openapi.notify;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import work.gaigeshen.tripartite.core.client.Clients;
import work.gaigeshen.tripartite.core.notify.AbstractNotifyContentReceiver;
import work.gaigeshen.tripartite.core.notify.DefaultNotifyContent;
import work.gaigeshen.tripartite.core.notify.NotifyContentIncorrectException;
import work.gaigeshen.tripartite.core.util.ArgumentValidate;
import work.gaigeshen.tripartite.core.util.json.JsonCodec;
import work.gaigeshen.tripartite.ding.openapi.config.DingConfig;

public class DingNotifyContentReceiver
extends AbstractNotifyContentReceiver<DefaultNotifyContent> {
    private final Clients<DingConfig> dingClients;

    public DingNotifyContentReceiver(Clients<DingConfig> clients) {
        ArgumentValidate.notNull(clients, (String)"clients cannot be null");
        this.dingClients = clients;
    }

    protected DefaultNotifyContent validate(DefaultNotifyContent content) throws NotifyContentIncorrectException {
        String appKey = (String)content.getValue("app_key");
        if (Objects.isNull(appKey)) {
            throw new NotifyContentIncorrectException("could not find [app_key] parameter: " + content);
        }
        DingConfig dingConfig = (DingConfig)this.dingClients.getConfig(cfg -> Objects.equals(cfg.getAppKey(), appKey));
        content.put("ding_config", (Object)dingConfig);
        String signature = (String)content.getValue("msg_signature");
        if (Objects.isNull(signature)) {
            throw new NotifyContentIncorrectException("could not find [msg_signature] parameter: " + content);
        }
        String timestamp = (String)content.getValue("timestamp");
        if (Objects.isNull(timestamp)) {
            throw new NotifyContentIncorrectException("could not find [timestamp] parameter: " + content);
        }
        String nonce = (String)content.getValue("nonce");
        if (Objects.isNull(nonce)) {
            throw new NotifyContentIncorrectException("could not find [nonce] parameter: " + content);
        }
        String bodyString = content.getBodyAsString();
        if (Objects.isNull(bodyString)) {
            throw new NotifyContentIncorrectException("could not find request body: " + content);
        }
        Map bodyDecoded = JsonCodec.instance().decodeObject(bodyString);
        String encrypted = (String)bodyDecoded.get("encrypt");
        if (Objects.isNull(encrypted)) {
            throw new NotifyContentIncorrectException("could not find [encrypt] field of request body: " + content);
        }
        if (!Objects.equals(DingNotifyContentReceiver.genSignature(dingConfig, timestamp, nonce, encrypted), signature)) {
            throw new NotifyContentIncorrectException("invalid signature: " + content);
        }
        try {
            content.put("decrypted", (Object)DingNotifyContentReceiver.decrypt(dingConfig, encrypted));
        }
        catch (GeneralSecurityException e) {
            throw new NotifyContentIncorrectException("could not decrypt: " + content, (Throwable)e);
        }
        return content;
    }

    public static String genSignature(DingConfig config, String timestamp, String nonce, String encrypted) {
        ArgumentValidate.notNull((Object)config, (String)"config cannot be null");
        ArgumentValidate.notTrue((Objects.isNull(timestamp) || Objects.isNull(nonce) || Objects.isNull(encrypted) ? 1 : 0) != 0, (String)"timestamp and nonce and encrypted cannot be null");
        Object[] message = new String[]{config.getToken(), timestamp, nonce, encrypted};
        Arrays.sort(message);
        return DigestUtils.sha1Hex((String)String.join((CharSequence)"", (CharSequence[])message));
    }

    public static String encrypt(DingConfig config, String plainText) throws GeneralSecurityException {
        ArgumentValidate.notNull((Object)config, (String)"config cannot be null");
        ArgumentValidate.notNull((Object)plainText, (String)"plainText cannot be null");
        byte[] secretKeyBytes = Base64.decodeBase64((String)(config.getSecretKey() + "="));
        byte[] randomBytes = RandomStringUtils.randomAscii((int)16).getBytes();
        byte[] plainTextBytes = plainText.getBytes();
        byte[] appKeyBytes = config.getAppKey().getBytes();
        byte[] plainTextLenBytes = new byte[]{(byte)(plainTextBytes.length >> 24 & 0xFF), (byte)(plainTextBytes.length >> 16 & 0xFF), (byte)(plainTextBytes.length >> 8 & 0xFF), (byte)(plainTextBytes.length & 0xFF)};
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            byteStream.write(randomBytes);
            byteStream.write(plainTextLenBytes);
            byteStream.write(plainTextBytes);
            byteStream.write(appKeyBytes);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        int padCount = 32 - byteStream.size() % 32;
        byte padChar = (byte)(padCount & 0xFF);
        for (int i = 0; i < padCount; ++i) {
            byteStream.write(padChar);
        }
        byte[] allBytes = byteStream.toByteArray();
        SecretKeySpec keySpec = new SecretKeySpec(secretKeyBytes, "AES");
        IvParameterSpec paramSpec = new IvParameterSpec(secretKeyBytes, 0, 16);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)keySpec, paramSpec);
        byte[] encrypted = cipher.doFinal(allBytes);
        return Base64.encodeBase64String((byte[])encrypted);
    }

    public static String decrypt(DingConfig config, String encrypted) throws GeneralSecurityException {
        ArgumentValidate.notNull((Object)config, (String)"config cannot be null");
        ArgumentValidate.notNull((Object)encrypted, (String)"encrypted cannot be null");
        byte[] secretKeyBytes = Base64.decodeBase64((String)(config.getSecretKey() + "="));
        SecretKeySpec keySpec = new SecretKeySpec(secretKeyBytes, "AES");
        IvParameterSpec paramSpec = new IvParameterSpec(secretKeyBytes, 0, 16);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)keySpec, paramSpec);
        byte[] decrypted = cipher.doFinal(Base64.decodeBase64((String)encrypted));
        byte padChar = decrypted[decrypted.length - 1];
        byte[] allBytes = Arrays.copyOfRange(decrypted, 0, decrypted.length - padChar);
        byte[] plainTextBytesLen = Arrays.copyOfRange(allBytes, 16, 20);
        int plainTextLen = 0;
        for (int i = 0; i < 4; ++i) {
            plainTextLen <<= 8;
            plainTextLen |= plainTextBytesLen[i] & 0xFF;
        }
        return new String(Arrays.copyOfRange(allBytes, 20, 20 + plainTextLen));
    }
}

