/*
 * Decompiled with CFR 0.152.
 */
package indi.rg.web.component.id;

import indi.rg.web.component.id.RcUniqueIdGenerator;
import indi.rg.web.component.redis.RcRedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class RcIdGeneratorConfig {
    private static final Logger logger = LoggerFactory.getLogger(RcIdGeneratorConfig.class);
    @Autowired
    private RcRedisUtil rcRedisUtil;
    private long workId;
    private long datacenterId;
    private long workNo;
    private static final long NODE_CODE_EXPIRATION = 3600L;

    @Bean
    public RcUniqueIdGenerator keyFactory() {
        long workNo = this.getWorkNo();
        long[] nodeCode = this.getNodeCode(workNo);
        this.workId = nodeCode[1];
        this.datacenterId = nodeCode[0];
        this.workNo = workNo;
        logger.info("\u52a8\u6001\u5206\u914d\u96ea\u82b1\u5de5\u4f5c\u7ed3\u70b9\uff0cworkNo:\u3010{}\u3011, datacenterId:\u3010{}\u3011, workId:\u3010{}\u3011", new Object[]{workNo, this.datacenterId, this.workId});
        return new RcUniqueIdGenerator(this.workId, this.datacenterId);
    }

    @Scheduled(cron="18 0/30 * * * ? ")
    public void nodeCodeHeartBeat() {
        String workNoKey = String.format("snowflake:no:%d", this.workNo);
        this.rcRedisUtil.set(workNoKey, System.currentTimeMillis(), 3600L);
        logger.info("\u5b8c\u6210\u96ea\u82b1\u7b97\u6cd5\u5de5\u4f5c\u7ed3\u70b9\u7eed\u7ea6\uff0cworkNo:\u3010{}\u3011, datacenterId:\u3010{}\u3011, workId:\u3010{}\u3011", new Object[]{this.workNo, this.datacenterId, this.workId});
    }

    public long[] getNodeCode(long workNo) {
        long workerId = workNo % 32L;
        long datacenterId = workNo / 32L;
        return new long[]{datacenterId, workerId};
    }

    private long getWorkNo() {
        long workNo;
        String workNoKey;
        boolean used;
        String key = "snowflake:counter";
        do {
            if ((workNo = this.rcRedisUtil.incr(key, 1L)) != 10000L) continue;
            this.rcRedisUtil.set(key, 0);
        } while (used = this.rcRedisUtil.hasKey(workNoKey = String.format("snowflake:no:%d", workNo)));
        this.rcRedisUtil.set(workNoKey, System.currentTimeMillis(), 3600L);
        return workNo % 1024L;
    }
}

