/*
 * Decompiled with CFR 0.152.
 */
package indi.rg.web.component.mybatis.interceptor;

import indi.rg.core.api.RoPageRequestParamBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class RcDatabasePageInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(RcDatabasePageInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String sql = boundSql.getSql();
            Object object = boundSql.getParameterObject();
            if (object instanceof RoPageRequestParamBuilder) {
                RoPageRequestParamBuilder paramBuilder = (RoPageRequestParamBuilder)object;
                String countSql = this.concatCountSql(sql);
                String pageSql = this.concatPageSql(sql, paramBuilder);
                Connection connection = (Connection)invocation.getArgs()[0];
                PreparedStatement countStmt = null;
                ResultSet rs = null;
                long totalCount = 0L;
                try {
                    countStmt = connection.prepareStatement(countSql);
                    ParameterHandler parameterHandler = (ParameterHandler)metaStatementHandler.getValue("delegate.parameterHandler");
                    parameterHandler.setParameters(countStmt);
                    rs = countStmt.executeQuery();
                    if (rs.next()) {
                        totalCount = rs.getLong(1);
                    }
                }
                catch (SQLException e) {
                    logger.error("\u5206\u9875\u62e6\u622a\u5931\u8d25", (Throwable)e);
                }
                finally {
                    try {
                        rs.close();
                        countStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                metaStatementHandler.setValue("delegate.boundSql.sql", (Object)pageSql);
                paramBuilder.setTotalCount(Long.valueOf(totalCount));
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        logger.info("start postgres Page Interceptor....");
    }

    public String concatCountSql(String sql) {
        return "select count(*) from (" + sql + ") a";
    }

    public String concatPageSql(String sql, RoPageRequestParamBuilder paramBuilder) {
        StringBuffer sb = new StringBuffer();
        sb.append(sql);
        String orderSql = paramBuilder.getOrderSql();
        if (StringUtils.isNotBlank((CharSequence)orderSql)) {
            sb.append(" ");
            sb.append(orderSql);
        }
        sb.append(" limit ").append(paramBuilder.getPageSize()).append(" offset ").append(paramBuilder.getOffset());
        return sb.toString();
    }
}

