/*
 * Decompiled with CFR 0.152.
 */
package indi.rg.web.component.mybatis.typehanlder;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.BLOB})
@MappedTypes(value={String.class})
public class RcBytesToStringTypeHandler
extends BaseTypeHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(RcBytesToStringTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setBytes(i, this.stringToBytes(parameter));
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs.getString(columnName);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getString(columnIndex);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getString(columnIndex);
    }

    private byte[] stringToBytes(String satelliteTle) {
        if (StringUtils.isEmpty((CharSequence)satelliteTle)) {
            return null;
        }
        try {
            return satelliteTle.getBytes("UTF-8");
        }
        catch (Exception e) {
            log.error("stringToBytes exception,", (Throwable)e);
            return null;
        }
    }
}

