/*
 * Decompiled with CFR 0.152.
 */
package indi.rg.web.component.mybatis.typehanlder;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedJdbcTypes(value={JdbcType.ARRAY})
@MappedTypes(value={Double[].class})
public class RcDoubleArrayTypeHandler
extends BaseTypeHandler<Double[]> {
    private static final Logger logger = LoggerFactory.getLogger(RcDoubleArrayTypeHandler.class);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Double[] parameter, JdbcType jdbcType) throws SQLException {
        Connection conn = preparedStatement.getConnection();
        Array array = conn.createArrayOf("double", parameter);
        preparedStatement.setArray(i, array);
    }

    public Double[] getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return this.getArray(resultSet.getArray(s));
    }

    public Double[] getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return this.getArray(resultSet.getArray(i));
    }

    public Double[] getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return this.getArray(callableStatement.getArray(i));
    }

    private Double[] getArray(Array array) {
        if (array == null) {
            return null;
        }
        try {
            return (Double[])array.getArray();
        }
        catch (SQLException ex) {
            logger.error("\u6570\u7ec4\u8f6c\u6362\u5931\u8d25:{}", (Object)array, (Object)ex);
            return null;
        }
    }
}

