/*
 * Decompiled with CFR 0.152.
 */
package indi.rg.web.component.web;

import com.google.common.base.Joiner;
import indi.rg.core.api.ReApiErrorType;
import indi.rg.core.api.RoApiResult;
import indi.rg.core.exception.RoCustomException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class RcGlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        this.logger.error((Object)"\u7cfb\u7edf\u9519\u8bef", (Throwable)ex);
        String msg = ex.getMessage();
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)statusCode)) {
            request.setAttribute("jakarta.servlet.error.exception", (Object)ex, 0);
        }
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)ex;
            FieldError fieldError = exception.getBindingResult().getFieldError();
            msg = fieldError.getDefaultMessage();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new ResponseEntity((Object)RoApiResult.error((int)ReApiErrorType.CUSTOM_ERROR.getCode(), (String)msg), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={RoCustomException.class})
    ResponseEntity<?> handleSBaseException(HttpServletRequest request, RoCustomException ex) {
        this.logger.warn((Object)"\u8fd0\u884c\u5f02\u5e38", (Throwable)ex);
        return new ResponseEntity((Object)RoApiResult.error((int)ex.getCode(), (String)ex.getMessage(), null), (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<?> validationErrorHandler(ConstraintViolationException ex) {
        List errorInfos = ex.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
        String errMsg = Joiner.on((String)",").join(errorInfos);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new ResponseEntity((Object)RoApiResult.error((int)400, (String)errMsg), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @ExceptionHandler(value={RuntimeException.class})
    ResponseEntity<?> handleRuntimeException(HttpServletRequest request, RuntimeException ex) {
        this.logger.error((Object)"\u8fd0\u884c\u5f02\u5e38", (Throwable)ex);
        RoApiResult errResp = RoApiResult.error((int)ReApiErrorType.CUSTOM_ERROR.getCode(), (String)"\u8fd0\u884c\u5f02\u5e38");
        return new ResponseEntity((Object)errResp, (HttpStatusCode)HttpStatus.OK);
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }
}

