/*
 * Decompiled with CFR 0.152.
 */
package works.bosk.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import works.bosk.DriverFactory;
import works.bosk.StateTreeNode;

public class BoskLogFilter
extends Filter<ILoggingEvent> {
    private static final ConcurrentHashMap<String, LogController> controllersByBoskID = new ConcurrentHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(BoskLogFilter.class);

    public static <R extends StateTreeNode> DriverFactory<R> withOverrides(Level level, Class<?> ... loggers) {
        LogController controller = new LogController();
        controller.setLogging(level, loggers);
        return BoskLogFilter.withController(controller);
    }

    public static <R extends StateTreeNode> DriverFactory<R> withController(LogController controller) {
        return (b, d) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering controller {} for bosk {} \"{}\"", new Object[]{System.identityHashCode(controller), b.instanceID(), b.name(), new Exception("Stack trace")});
            }
            LogController old = controllersByBoskID.put(b.instanceID().toString(), controller);
            assert (old == null) : "Must not create two log controllers for the same bosk. name:\"" + b.name() + "\" id:\"" + b.instanceID() + "\"";
            return d;
        };
    }

    public FilterReply decide(ILoggingEvent event) {
        String boskID = MDC.get((String)"bosk.instanceID");
        if (boskID == null) {
            return FilterReply.NEUTRAL;
        }
        LogController controller = controllersByBoskID.get(boskID);
        if (controller == null) {
            return FilterReply.NEUTRAL;
        }
        Level level = controller.overrides.get(event.getLoggerName());
        if (level == null) {
            return FilterReply.NEUTRAL;
        }
        if (event.getLevel().isGreaterOrEqual(level)) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public static final class LogController {
        final Map<String, Level> overrides = new ConcurrentHashMap<String, Level>();

        public void setLogging(Level level, Class<?> ... loggers) {
            this.overrides.putAll(Stream.of(loggers).collect(Collectors.toMap(Class::getName, c -> level)));
        }
    }
}

