/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.core.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import org.springframework.core.io.ClassPathResource;

public class JwtUtils {
    private static String SECRET = "";

    public static String getToken(Map<String, String> map) {
        return JwtUtils.getToken(map, 5, 1);
    }

    public static String getToken(Map<String, String> map, Integer calenderType, Integer count) {
        Calendar instance = Calendar.getInstance();
        instance.add(calenderType, count);
        JWTCreator.Builder builder = JWT.create();
        map.forEach((k, v) -> builder.withClaim(k, v));
        builder.withExpiresAt(instance.getTime());
        return builder.sign(Algorithm.HMAC256((String)SECRET));
    }

    public static void validate(String token) {
        JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
    }

    public static Map<String, String> getValidationsObjects(String token) {
        DecodedJWT verify = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
        Map claims = verify.getClaims();
        HashMap<String, String> result = new HashMap<String, String>();
        claims.forEach((k, v) -> result.put((String)k, v.asString()));
        return result;
    }

    static {
        String target = "jwt_secret.txt";
        StringBuilder stringBuilder = new StringBuilder();
        try (Scanner scanner = new Scanner(new ClassPathResource(target).getInputStream(), StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                stringBuilder.append(scanner.nextLine());
            }
            SECRET = stringBuilder.toString();
        }
        catch (IOException e) {
            SECRET = UUID.randomUUID().toString();
        }
    }
}

