/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.core.util;

import java.util.Random;

public class RandomUtils {
    public static final int DEFAULT_DOUBLE_PRECISION = 2;
    public static final String EN_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String NUM_CHARS = "0123456789";
    public static final String EN_NUM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public static Integer randomInt(Integer min, Integer max) {
        if (min >= max) {
            throw new IllegalArgumentException("Min Value Must Be Less Than Max Value");
        }
        min = min <= 0 ? 1 : min;
        Random random = new Random();
        return random.nextInt(max - min + 1) + min;
    }

    public static Integer randomInt() {
        return RandomUtils.randomInt(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static Double randomDouble(Double min, Double max, Integer precision) {
        if (min >= max || precision < 0) {
            throw new IllegalArgumentException("Invalid input parameters");
        }
        Random random = new Random();
        double randomValue = min + (max - min) * random.nextDouble();
        double scaleFactor = Math.pow(10.0, precision.intValue());
        return (double)Math.round(randomValue * scaleFactor) / scaleFactor;
    }

    public static Double randomDouble(Double min, Double max) {
        return RandomUtils.randomDouble(min, max, 2);
    }

    public static Double randomDouble() {
        return RandomUtils.randomDouble(Double.MIN_VALUE, Double.MAX_VALUE, 2);
    }

    public static Double randomDouble(Integer precision) {
        return RandomUtils.randomDouble(Double.MIN_VALUE, Double.MAX_VALUE, precision);
    }

    public static String randomStr(Integer len, String characters) {
        if (len <= 0) {
            throw new IllegalArgumentException("Length Must Be Greater Than 0");
        }
        StringBuilder stringBuilder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int randomIndex = RandomUtils.randomInt(0, characters.length() - 1);
            char randomChar = characters.charAt(randomIndex);
            stringBuilder.append(randomChar);
        }
        return stringBuilder.toString();
    }

    public static String randomEnStr(Integer len) {
        return RandomUtils.randomStr(len, EN_CHARS);
    }

    public static String randomCode(Integer len) {
        return RandomUtils.randomStr(len, EN_NUM_CHARS);
    }

    public static String randomEnCode(Integer len) {
        return RandomUtils.randomEnStr(len);
    }

    public static String randomNumCode(Integer len) {
        return RandomUtils.randomStr(len, NUM_CHARS);
    }

    public static String randomCnStr(Integer len) {
        if (len <= 0) {
            throw new IllegalArgumentException("Length Must Be Greater Than 0");
        }
        StringBuilder stringBuilder = new StringBuilder(len);
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            char randomCnChar = (char)(19968 + random.nextInt(20992));
            stringBuilder.append(randomCnChar);
        }
        return stringBuilder.toString();
    }
}

