/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.mime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wtf.g4s8.mime.MimeType;

final class MimeTypeOfString
implements MimeType {
    private static final Pattern PTN_TYPE;
    private static final Pattern PTN_PARAM;
    private final CharSequence src;
    private volatile Map<String, String> parmap;

    public MimeTypeOfString(CharSequence src) {
        this.src = src;
    }

    @Override
    public String type() {
        return this.typeMatcher().group(1).toLowerCase(Locale.US);
    }

    @Override
    public String subtype() {
        return this.typeMatcher().group(2).toLowerCase(Locale.US);
    }

    @Override
    public Set<String> params() {
        return this.paramsMap().keySet();
    }

    @Override
    public Optional<String> param(String name) {
        return Optional.ofNullable(this.paramsMap().get(name.toLowerCase(Locale.US)));
    }

    public String toString() {
        return this.src.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MimeTypeOfString)) {
            return false;
        }
        MimeTypeOfString other = (MimeTypeOfString)obj;
        return Objects.equals(this.src, other.src);
    }

    public int hashCode() {
        return this.src.hashCode();
    }

    private Matcher typeMatcher() {
        Matcher matcher = PTN_TYPE.matcher(this.src);
        if (!matcher.lookingAt()) {
            throw new IllegalStateException("Invalid mime type format");
        }
        return matcher;
    }

    private Map<String, String> paramsMap() {
        if (this.parmap == null) {
            Matcher matcher = this.typeMatcher();
            String str = this.src.toString().trim();
            Matcher param = PTN_PARAM.matcher(str);
            HashMap<String, String> map = new HashMap<String, String>();
            int id = matcher.end();
            if (id + 1 <= str.length() && str.charAt(id) == ';') {
                ++id;
            } else {
                this.parmap = Collections.emptyMap();
                return this.parmap;
            }
            while (id < str.length()) {
                param.region(id, str.length());
                if (!param.lookingAt()) {
                    throw new IllegalStateException(String.format("Invalid mime-type params: %s", param));
                }
                String name = param.group(1).toLowerCase(Locale.US);
                if (map.containsKey(name)) {
                    throw new IllegalStateException(String.format("Parameter %s may only exist once.", name));
                }
                map.put(name, MimeTypeOfString.paramValue(param));
                id = param.end();
            }
            this.parmap = map;
        }
        return Collections.unmodifiableMap(this.parmap);
    }

    private static String paramValue(Matcher matcher) {
        String token = matcher.group(2);
        String value = token == null ? matcher.group(3) : (token.length() > 2 && token.charAt(0) == '\'' && token.charAt(token.length() - 1) == '\'' ? token.substring(1, token.length() - 1) : token);
        if (value == null) {
            throw new IllegalStateException("Bad parameter value");
        }
        return value;
    }

    static {
        String token = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
        PTN_TYPE = Pattern.compile(String.format("%s/%s", "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)", "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)"));
        PTN_PARAM = Pattern.compile(String.format("\\s*(?:%s=(?:%s|\"([^\"]*)\")[;]?)?", "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)", "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)"));
    }
}

