/*
 * SPDX-FileCopyrightText: The memoization.java Authors
 * SPDX-License-Identifier: 0BSD
 */
package wtf.metio.memoization.jdk;

import wtf.metio.memoization.core.AbstractMemoizer;

import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;

import static java.util.Objects.requireNonNull;

final class DoubleConsumerMemoizer<KEY>
        extends AbstractMemoizer<KEY, KEY>
        implements DoubleConsumer {

    private final DoubleFunction<KEY> keyFunction;
    private final DoubleConsumer consumer;

    DoubleConsumerMemoizer(
            final ConcurrentMap<KEY, KEY> cache,
            final DoubleFunction<KEY> keyFunction,
            final DoubleConsumer consumer) {
        super(cache);
        this.keyFunction = requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = requireNonNull(consumer,
                "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(final double value) {
        computeIfAbsent(keyFunction.apply(value), key -> {
            consumer.accept(value);
            return key;
        });
    }

}
