/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class BiConsumerMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, KEY>
implements BiConsumer<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiConsumer<FIRST, SECOND> biConsumer;

    BiConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiConsumer<FIRST, SECOND> biConsumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biConsumer = Objects.requireNonNull(biConsumer, "Cannot memoize a NULL BiConsumer - provide an actual BiConsumer to fix this.");
    }

    @Override
    public void accept(FIRST first, SECOND second) {
        this.computeIfAbsent(this.keyFunction.apply(first, second), key -> {
            this.biConsumer.accept(first, second);
            return key;
        });
    }
}

