/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class BiFunctionMemoizer<FIRST, SECOND, KEY, VALUE>
extends AbstractMemoizer<KEY, VALUE>
implements BiFunction<FIRST, SECOND, VALUE> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiFunction<FIRST, SECOND, VALUE> biFunction;

    BiFunctionMemoizer(ConcurrentMap<KEY, VALUE> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiFunction<FIRST, SECOND, VALUE> biFunction) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biFunction = Objects.requireNonNull(biFunction, "Cannot memoize a NULL BiFunction - provide an actual BiFunction to fix this.");
    }

    @Override
    public VALUE apply(FIRST first, SECOND second) {
        return (VALUE)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.biFunction.apply(first, second));
    }
}

